package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Roleprivileges;
import microsoft.dynamics.crm.entity.request.RoleprivilegesRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class RoleprivilegesCollectionRequest extends CollectionPageEntityRequest<Roleprivileges, RoleprivilegesRequest>{

    protected ContextPath contextPath;

    public RoleprivilegesCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Roleprivileges.class, cp -> new RoleprivilegesRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
