package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Role;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.AppmoduleRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.PrivilegeRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class RoleCollectionRequest extends CollectionPageEntityRequest<Role, RoleRequest>{

    protected ContextPath contextPath;

    public RoleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Role.class, cp -> new RoleRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SystemuserCollectionRequest systemuserroles_association() {
        return new SystemuserCollectionRequest(contextPath.addSegment("systemuserroles_association"), Optional.empty());
    }

    public SystemuserRequest systemuserroles_association(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("systemuserroles_association").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public PrivilegeCollectionRequest roleprivileges_association() {
        return new PrivilegeCollectionRequest(contextPath.addSegment("roleprivileges_association"), Optional.empty());
    }

    public PrivilegeRequest roleprivileges_association(String privilegeid) {
        return new PrivilegeRequest(contextPath.addSegment("roleprivileges_association").addKeys(new NameValue(privilegeid.toString())), Optional.empty());
    }

    public AppmoduleCollectionRequest appmoduleroles_association() {
        return new AppmoduleCollectionRequest(contextPath.addSegment("appmoduleroles_association"), Optional.empty());
    }

    public AppmoduleRequest appmoduleroles_association(String appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("appmoduleroles_association").addKeys(new NameValue(appmoduleid.toString())), Optional.empty());
    }

    public RoleCollectionRequest role_parent_role() {
        return new RoleCollectionRequest(contextPath.addSegment("role_parent_role"), Optional.empty());
    }

    public RoleRequest role_parent_role(String roleid) {
        return new RoleRequest(contextPath.addSegment("role_parent_role").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest role_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Role_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest role_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Role_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest role_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Role_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest role_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Role_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public TeamCollectionRequest teamroles_association() {
        return new TeamCollectionRequest(contextPath.addSegment("teamroles_association"), Optional.empty());
    }

    public TeamRequest teamroles_association(String ownerid) {
        return new TeamRequest(contextPath.addSegment("teamroles_association").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public RoleCollectionRequest role_parent_root_role() {
        return new RoleCollectionRequest(contextPath.addSegment("role_parent_root_role"), Optional.empty());
    }

    public RoleRequest role_parent_root_role(String roleid) {
        return new RoleRequest(contextPath.addSegment("role_parent_root_role").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest role_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Role_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest role_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Role_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public ApplicationuserCollectionRequest applicationuserrole() {
        return new ApplicationuserCollectionRequest(contextPath.addSegment("applicationuserrole"), Optional.empty());
    }

    public ApplicationuserRequest applicationuserrole(String applicationuserid) {
        return new ApplicationuserRequest(contextPath.addSegment("applicationuserrole").addKeys(new NameValue(applicationuserid.toString())), Optional.empty());
    }

}
