package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Report;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.ReportRequest;
import microsoft.dynamics.crm.entity.request.ReportcategoryRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class ReportCollectionRequest extends CollectionPageEntityRequest<Report, ReportRequest>{

    protected ContextPath contextPath;

    public ReportCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Report.class, cp -> new ReportRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public AsyncoperationCollectionRequest report_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Report_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest report_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Report_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ReportcategoryCollectionRequest report_reportcategories() {
        return new ReportcategoryCollectionRequest(contextPath.addSegment("report_reportcategories"), Optional.empty());
    }

    public ReportcategoryRequest report_reportcategories(String reportcategoryid) {
        return new ReportcategoryRequest(contextPath.addSegment("report_reportcategories").addKeys(new NameValue(reportcategoryid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest report_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Report_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest report_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Report_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest report_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Report_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest report_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Report_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public ReportCollectionRequest report_parent_report() {
        return new ReportCollectionRequest(contextPath.addSegment("report_parent_report"), Optional.empty());
    }

    public ReportRequest report_parent_report(String reportid) {
        return new ReportRequest(contextPath.addSegment("report_parent_report").addKeys(new NameValue(reportid.toString())), Optional.empty());
    }

}
