package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Relationshipattribute;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.RelationshipattributeRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class RelationshipattributeCollectionRequest extends CollectionPageEntityRequest<Relationshipattribute, RelationshipattributeRequest>{

    protected ContextPath contextPath;

    public RelationshipattributeCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Relationshipattribute.class, cp -> new RelationshipattributeRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest relationshipattribute_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("relationshipattribute_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest relationshipattribute_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("relationshipattribute_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest relationshipattribute_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("relationshipattribute_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest relationshipattribute_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("relationshipattribute_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest relationshipattribute_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("relationshipattribute_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest relationshipattribute_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("relationshipattribute_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest relationshipattribute_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("relationshipattribute_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest relationshipattribute_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("relationshipattribute_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest relationshipattribute_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("relationshipattribute_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest relationshipattribute_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("relationshipattribute_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

}
