package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.RelationshipMetadataBase;
import microsoft.dynamics.crm.entity.request.RelationshipMetadataBaseRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class RelationshipMetadataBaseCollectionRequest extends CollectionPageEntityRequest<RelationshipMetadataBase, RelationshipMetadataBaseRequest>{

    protected ContextPath contextPath;

    public RelationshipMetadataBaseCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, RelationshipMetadataBase.class, cp -> new RelationshipMetadataBaseRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
