package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Recurrencerule;
import microsoft.dynamics.crm.entity.request.RecurrenceruleRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class RecurrenceruleCollectionRequest extends CollectionPageEntityRequest<Recurrencerule, RecurrenceruleRequest>{

    protected ContextPath contextPath;

    public RecurrenceruleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Recurrencerule.class, cp -> new RecurrenceruleRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public RecurringappointmentmasterCollectionRequest recurrencerule_recurringappointmentmaster() {
        return new RecurringappointmentmasterCollectionRequest(contextPath.addSegment("recurrencerule_recurringappointmentmaster"), Optional.empty());
    }

    public RecurringappointmentmasterRequest recurrencerule_recurringappointmentmaster(String activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("recurrencerule_recurringappointmentmaster").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

}
