package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Queuemembership;
import microsoft.dynamics.crm.entity.request.QueuemembershipRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class QueuemembershipCollectionRequest extends CollectionPageEntityRequest<Queuemembership, QueuemembershipRequest>{

    protected ContextPath contextPath;

    public QueuemembershipCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Queuemembership.class, cp -> new QueuemembershipRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
