package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Queueitem;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class QueueitemCollectionRequest extends CollectionPageEntityRequest<Queueitem, QueueitemRequest>{

    protected ContextPath contextPath;

    public QueueitemCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Queueitem.class, cp -> new QueueitemRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public ProcesssessionCollectionRequest queueItem_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("QueueItem_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest queueItem_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("QueueItem_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest queueItem_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("QueueItem_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest queueItem_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("QueueItem_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest queueItem_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("QueueItem_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest queueItem_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("QueueItem_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest queueitem_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("queueitem_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest queueitem_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("queueitem_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest queueItem_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("QueueItem_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest queueItem_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("QueueItem_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

}
