package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Publisher;
import microsoft.dynamics.crm.entity.request.AppmoduleRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.PublisherRequest;
import microsoft.dynamics.crm.entity.request.PublisheraddressRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class PublisherCollectionRequest extends CollectionPageEntityRequest<Publisher, PublisherRequest>{

    protected ContextPath contextPath;

    public PublisherCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Publisher.class, cp -> new PublisherRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public DuplicaterecordCollectionRequest publisher_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Publisher_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest publisher_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Publisher_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest publisher_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Publisher_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest publisher_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Publisher_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest publisher_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Publisher_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest publisher_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Publisher_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public SolutionCollectionRequest publisher_solution() {
        return new SolutionCollectionRequest(contextPath.addSegment("publisher_solution"), Optional.empty());
    }

    public SolutionRequest publisher_solution(String solutionid) {
        return new SolutionRequest(contextPath.addSegment("publisher_solution").addKeys(new NameValue(solutionid.toString())), Optional.empty());
    }

    public AppmoduleCollectionRequest publisher_appmodule() {
        return new AppmoduleCollectionRequest(contextPath.addSegment("publisher_appmodule"), Optional.empty());
    }

    public AppmoduleRequest publisher_appmodule(String appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("publisher_appmodule").addKeys(new NameValue(appmoduleid.toString())), Optional.empty());
    }

    public PublisheraddressCollectionRequest publisher_PublisherAddress() {
        return new PublisheraddressCollectionRequest(contextPath.addSegment("Publisher_PublisherAddress"), Optional.empty());
    }

    public PublisheraddressRequest publisher_PublisherAddress(String publisheraddressid) {
        return new PublisheraddressRequest(contextPath.addSegment("Publisher_PublisherAddress").addKeys(new NameValue(publisheraddressid.toString())), Optional.empty());
    }

}
