package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Processtrigger;
import microsoft.dynamics.crm.entity.request.ProcesstriggerRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class ProcesstriggerCollectionRequest extends CollectionPageEntityRequest<Processtrigger, ProcesstriggerRequest>{

    protected ContextPath contextPath;

    public ProcesstriggerCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Processtrigger.class, cp -> new ProcesstriggerRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest processTrigger_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ProcessTrigger_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest processTrigger_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ProcessTrigger_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
