package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Postcomment;
import microsoft.dynamics.crm.entity.request.PostcommentRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class PostcommentCollectionRequest extends CollectionPageEntityRequest<Postcomment, PostcommentRequest>{

    protected ContextPath contextPath;

    public PostcommentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Postcomment.class, cp -> new PostcommentRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
