package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Organization;
import microsoft.dynamics.crm.entity.request.AciviewmapperRequest;
import microsoft.dynamics.crm.entity.request.AppconfigRequest;
import microsoft.dynamics.crm.entity.request.AppconfiginstanceRequest;
import microsoft.dynamics.crm.entity.request.AppconfigmasterRequest;
import microsoft.dynamics.crm.entity.request.AppmoduleRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitnewsarticleRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.ComplexcontrolRequest;
import microsoft.dynamics.crm.entity.request.ConnectionroleRequest;
import microsoft.dynamics.crm.entity.request.CustomcontrolRequest;
import microsoft.dynamics.crm.entity.request.CustomcontroldefaultconfigRequest;
import microsoft.dynamics.crm.entity.request.CustomcontrolresourceRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspaceRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspacepermissionRequest;
import microsoft.dynamics.crm.entity.request.DataperformanceRequest;
import microsoft.dynamics.crm.entity.request.DisplaystringRequest;
import microsoft.dynamics.crm.entity.request.DocumenttemplateRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.EntityanalyticsconfigRequest;
import microsoft.dynamics.crm.entity.request.ExpiredprocessRequest;
import microsoft.dynamics.crm.entity.request.FieldsecurityprofileRequest;
import microsoft.dynamics.crm.entity.request.ImportjobRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KbarticletemplateRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LanguagelocaleRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.MetricRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileitemRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileitemassociationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_helppageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthrulesetRequest;
import microsoft.dynamics.crm.entity.request.NavigationsettingRequest;
import microsoft.dynamics.crm.entity.request.NewprocessRequest;
import microsoft.dynamics.crm.entity.request.OfficegraphdocumentRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PluginassemblyRequest;
import microsoft.dynamics.crm.entity.request.PlugintypeRequest;
import microsoft.dynamics.crm.entity.request.PlugintypestatisticRequest;
import microsoft.dynamics.crm.entity.request.PositionRequest;
import microsoft.dynamics.crm.entity.request.PostRequest;
import microsoft.dynamics.crm.entity.request.PostcommentRequest;
import microsoft.dynamics.crm.entity.request.PostlikeRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.PublisherRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.RecommendeddocumentRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.SavedqueryRequest;
import microsoft.dynamics.crm.entity.request.SavedqueryvisualizationRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageRequest;
import microsoft.dynamics.crm.entity.request.SdkmessagefilterRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepimageRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepsecureconfigRequest;
import microsoft.dynamics.crm.entity.request.ServiceendpointRequest;
import microsoft.dynamics.crm.entity.request.SimilarityruleRequest;
import microsoft.dynamics.crm.entity.request.SitemapRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentattributeconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentrelationshipconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SubjectRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemformRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TerritoryRequest;
import microsoft.dynamics.crm.entity.request.ThemeRequest;
import microsoft.dynamics.crm.entity.request.TracelogRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;
import microsoft.dynamics.crm.entity.request.TranslationprocessRequest;
import microsoft.dynamics.crm.entity.request.UsermappingRequest;
import microsoft.dynamics.crm.entity.request.WebresourceRequest;
import microsoft.dynamics.crm.entity.request.WebwizardRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class OrganizationCollectionRequest extends CollectionPageEntityRequest<Organization, OrganizationRequest>{

    protected ContextPath contextPath;

    public OrganizationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Organization.class, cp -> new OrganizationRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public PrincipalobjectattributeaccessCollectionRequest lk_principalobjectattributeaccess_organizationid() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("lk_principalobjectattributeaccess_organizationid"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest lk_principalobjectattributeaccess_organizationid(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("lk_principalobjectattributeaccess_organizationid").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public ThemeCollectionRequest organization_theme() {
        return new ThemeCollectionRequest(contextPath.addSegment("organization_theme"), Optional.empty());
    }

    public ThemeRequest organization_theme(String themeid) {
        return new ThemeRequest(contextPath.addSegment("organization_theme").addKeys(new NameValue(themeid.toString())), Optional.empty());
    }

    public UsermappingCollectionRequest organization_UserMapping() {
        return new UsermappingCollectionRequest(contextPath.addSegment("organization_UserMapping"), Optional.empty());
    }

    public UsermappingRequest organization_UserMapping(String usermappingid) {
        return new UsermappingRequest(contextPath.addSegment("organization_UserMapping").addKeys(new NameValue(usermappingid.toString())), Optional.empty());
    }

    public MetricCollectionRequest organization_metric() {
        return new MetricCollectionRequest(contextPath.addSegment("organization_metric"), Optional.empty());
    }

    public MetricRequest organization_metric(String metricid) {
        return new MetricRequest(contextPath.addSegment("organization_metric").addKeys(new NameValue(metricid.toString())), Optional.empty());
    }

    public PositionCollectionRequest organization_position() {
        return new PositionCollectionRequest(contextPath.addSegment("organization_position"), Optional.empty());
    }

    public PositionRequest organization_position(String positionid) {
        return new PositionRequest(contextPath.addSegment("organization_position").addKeys(new NameValue(positionid.toString())), Optional.empty());
    }

    public OfficegraphdocumentCollectionRequest organization_officegraphdocument() {
        return new OfficegraphdocumentCollectionRequest(contextPath.addSegment("organization_officegraphdocument"), Optional.empty());
    }

    public OfficegraphdocumentRequest organization_officegraphdocument(String officegraphdocumentid) {
        return new OfficegraphdocumentRequest(contextPath.addSegment("organization_officegraphdocument").addKeys(new NameValue(officegraphdocumentid.toString())), Optional.empty());
    }

    public RecommendeddocumentCollectionRequest organization_recommendeddocument() {
        return new RecommendeddocumentCollectionRequest(contextPath.addSegment("organization_recommendeddocument"), Optional.empty());
    }

    public RecommendeddocumentRequest organization_recommendeddocument(String recommendeddocumentid) {
        return new RecommendeddocumentRequest(contextPath.addSegment("organization_recommendeddocument").addKeys(new NameValue(recommendeddocumentid.toString())), Optional.empty());
    }

    public KnowledgebaserecordCollectionRequest organization_KnowledgeBaseRecord() {
        return new KnowledgebaserecordCollectionRequest(contextPath.addSegment("organization_KnowledgeBaseRecord"), Optional.empty());
    }

    public KnowledgebaserecordRequest organization_KnowledgeBaseRecord(String knowledgebaserecordid) {
        return new KnowledgebaserecordRequest(contextPath.addSegment("organization_KnowledgeBaseRecord").addKeys(new NameValue(knowledgebaserecordid.toString())), Optional.empty());
    }

    public SdkmessagefilterCollectionRequest organization_sdkmessagefilter() {
        return new SdkmessagefilterCollectionRequest(contextPath.addSegment("organization_sdkmessagefilter"), Optional.empty());
    }

    public SdkmessagefilterRequest organization_sdkmessagefilter(String sdkmessagefilterid) {
        return new SdkmessagefilterRequest(contextPath.addSegment("organization_sdkmessagefilter").addKeys(new NameValue(sdkmessagefilterid.toString())), Optional.empty());
    }

    public WebresourceCollectionRequest webresource_organization() {
        return new WebresourceCollectionRequest(contextPath.addSegment("webresource_organization"), Optional.empty());
    }

    public WebresourceRequest webresource_organization(String webresourceid) {
        return new WebresourceRequest(contextPath.addSegment("webresource_organization").addKeys(new NameValue(webresourceid.toString())), Optional.empty());
    }

    public PostCollectionRequest organization_post() {
        return new PostCollectionRequest(contextPath.addSegment("organization_post"), Optional.empty());
    }

    public PostRequest organization_post(String postid) {
        return new PostRequest(contextPath.addSegment("organization_post").addKeys(new NameValue(postid.toString())), Optional.empty());
    }

    public PostcommentCollectionRequest organization_PostComment() {
        return new PostcommentCollectionRequest(contextPath.addSegment("organization_PostComment"), Optional.empty());
    }

    public PostcommentRequest organization_PostComment(String postcommentid) {
        return new PostcommentRequest(contextPath.addSegment("organization_PostComment").addKeys(new NameValue(postcommentid.toString())), Optional.empty());
    }

    public PostlikeCollectionRequest organization_postlike() {
        return new PostlikeCollectionRequest(contextPath.addSegment("organization_postlike"), Optional.empty());
    }

    public PostlikeRequest organization_postlike(String postlikeid) {
        return new PostlikeRequest(contextPath.addSegment("organization_postlike").addKeys(new NameValue(postlikeid.toString())), Optional.empty());
    }

    public ImportjobCollectionRequest organization_importjob() {
        return new ImportjobCollectionRequest(contextPath.addSegment("organization_importjob"), Optional.empty());
    }

    public ImportjobRequest organization_importjob(String importjobid) {
        return new ImportjobRequest(contextPath.addSegment("organization_importjob").addKeys(new NameValue(importjobid.toString())), Optional.empty());
    }

    public QueueCollectionRequest organization_queues() {
        return new QueueCollectionRequest(contextPath.addSegment("organization_queues"), Optional.empty());
    }

    public QueueRequest organization_queues(String queueid) {
        return new QueueRequest(contextPath.addSegment("organization_queues").addKeys(new NameValue(queueid.toString())), Optional.empty());
    }

    public PluginassemblyCollectionRequest organization_pluginassembly() {
        return new PluginassemblyCollectionRequest(contextPath.addSegment("organization_pluginassembly"), Optional.empty());
    }

    public PluginassemblyRequest organization_pluginassembly(String pluginassemblyid) {
        return new PluginassemblyRequest(contextPath.addSegment("organization_pluginassembly").addKeys(new NameValue(pluginassemblyid.toString())), Optional.empty());
    }

    public FieldsecurityprofileCollectionRequest lk_fieldsecurityprofile_organizationid() {
        return new FieldsecurityprofileCollectionRequest(contextPath.addSegment("lk_fieldsecurityprofile_organizationid"), Optional.empty());
    }

    public FieldsecurityprofileRequest lk_fieldsecurityprofile_organizationid(String fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("lk_fieldsecurityprofile_organizationid").addKeys(new NameValue(fieldsecurityprofileid.toString())), Optional.empty());
    }

    public SimilarityruleCollectionRequest organization_similarityrule() {
        return new SimilarityruleCollectionRequest(contextPath.addSegment("organization_similarityrule"), Optional.empty());
    }

    public SimilarityruleRequest organization_similarityrule(String similarityruleid) {
        return new SimilarityruleRequest(contextPath.addSegment("organization_similarityrule").addKeys(new NameValue(similarityruleid.toString())), Optional.empty());
    }

    public ExpiredprocessCollectionRequest organization_expiredprocess() {
        return new ExpiredprocessCollectionRequest(contextPath.addSegment("organization_expiredprocess"), Optional.empty());
    }

    public ExpiredprocessRequest organization_expiredprocess(String businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("organization_expiredprocess").addKeys(new NameValue(businessprocessflowinstanceid.toString())), Optional.empty());
    }

    public AppconfiginstanceCollectionRequest organization_appconfiginstance() {
        return new AppconfiginstanceCollectionRequest(contextPath.addSegment("organization_appconfiginstance"), Optional.empty());
    }

    public AppconfiginstanceRequest organization_appconfiginstance(String appconfiginstanceid) {
        return new AppconfiginstanceRequest(contextPath.addSegment("organization_appconfiginstance").addKeys(new NameValue(appconfiginstanceid.toString())), Optional.empty());
    }

    public SavedqueryvisualizationCollectionRequest organization_saved_query_visualizations() {
        return new SavedqueryvisualizationCollectionRequest(contextPath.addSegment("organization_saved_query_visualizations"), Optional.empty());
    }

    public SavedqueryvisualizationRequest organization_saved_query_visualizations(String savedqueryvisualizationid) {
        return new SavedqueryvisualizationRequest(contextPath.addSegment("organization_saved_query_visualizations").addKeys(new NameValue(savedqueryvisualizationid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest organization_system_users() {
        return new SystemuserCollectionRequest(contextPath.addSegment("organization_system_users"), Optional.empty());
    }

    public SystemuserRequest organization_system_users(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("organization_system_users").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public PublisherCollectionRequest organization_publisher() {
        return new PublisherCollectionRequest(contextPath.addSegment("organization_publisher"), Optional.empty());
    }

    public PublisherRequest organization_publisher(String publisherid) {
        return new PublisherRequest(contextPath.addSegment("organization_publisher").addKeys(new NameValue(publisherid.toString())), Optional.empty());
    }

    public PlugintypeCollectionRequest organization_plugintype() {
        return new PlugintypeCollectionRequest(contextPath.addSegment("organization_plugintype"), Optional.empty());
    }

    public PlugintypeRequest organization_plugintype(String plugintypeid) {
        return new PlugintypeRequest(contextPath.addSegment("organization_plugintype").addKeys(new NameValue(plugintypeid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest organization_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Organization_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest organization_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Organization_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DataperformanceCollectionRequest lk_dataperformance_organizationid() {
        return new DataperformanceCollectionRequest(contextPath.addSegment("lk_dataperformance_organizationid"), Optional.empty());
    }

    public DataperformanceRequest lk_dataperformance_organizationid(String dataperformanceid) {
        return new DataperformanceRequest(contextPath.addSegment("lk_dataperformance_organizationid").addKeys(new NameValue(dataperformanceid.toString())), Optional.empty());
    }

    public ServiceendpointCollectionRequest organization_serviceendpoint() {
        return new ServiceendpointCollectionRequest(contextPath.addSegment("organization_serviceendpoint"), Optional.empty());
    }

    public ServiceendpointRequest organization_serviceendpoint(String serviceendpointid) {
        return new ServiceendpointRequest(contextPath.addSegment("organization_serviceendpoint").addKeys(new NameValue(serviceendpointid.toString())), Optional.empty());
    }

    public DisplaystringCollectionRequest organization_custom_displaystrings() {
        return new DisplaystringCollectionRequest(contextPath.addSegment("organization_custom_displaystrings"), Optional.empty());
    }

    public DisplaystringRequest organization_custom_displaystrings(String displaystringid) {
        return new DisplaystringRequest(contextPath.addSegment("organization_custom_displaystrings").addKeys(new NameValue(displaystringid.toString())), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest organization_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(contextPath.addSegment("organization_sdkmessageprocessingstep"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest organization_sdkmessageprocessingstep(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("organization_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

    public PlugintypestatisticCollectionRequest organization_plugintypestatistic() {
        return new PlugintypestatisticCollectionRequest(contextPath.addSegment("organization_plugintypestatistic"), Optional.empty());
    }

    public PlugintypestatisticRequest organization_plugintypestatistic(String plugintypestatisticid) {
        return new PlugintypestatisticRequest(contextPath.addSegment("organization_plugintypestatistic").addKeys(new NameValue(plugintypestatisticid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest organization_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Organization_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest organization_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Organization_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public EmailserverprofileCollectionRequest organization_emailserverprofile() {
        return new EmailserverprofileCollectionRequest(contextPath.addSegment("organization_emailserverprofile"), Optional.empty());
    }

    public EmailserverprofileRequest organization_emailserverprofile(String emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("organization_emailserverprofile").addKeys(new NameValue(emailserverprofileid.toString())), Optional.empty());
    }

    public SavedqueryCollectionRequest organization_saved_queries() {
        return new SavedqueryCollectionRequest(contextPath.addSegment("organization_saved_queries"), Optional.empty());
    }

    public SavedqueryRequest organization_saved_queries(String savedqueryid) {
        return new SavedqueryRequest(contextPath.addSegment("organization_saved_queries").addKeys(new NameValue(savedqueryid.toString())), Optional.empty());
    }

    public SitemapCollectionRequest organization_sitemap() {
        return new SitemapCollectionRequest(contextPath.addSegment("organization_sitemap"), Optional.empty());
    }

    public SitemapRequest organization_sitemap(String sitemapid) {
        return new SitemapRequest(contextPath.addSegment("organization_sitemap").addKeys(new NameValue(sitemapid.toString())), Optional.empty());
    }

    public TeamCollectionRequest organization_teams() {
        return new TeamCollectionRequest(contextPath.addSegment("organization_teams"), Optional.empty());
    }

    public TeamRequest organization_teams(String ownerid) {
        return new TeamRequest(contextPath.addSegment("organization_teams").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public DocumenttemplateCollectionRequest lk_documenttemplatebase_organization() {
        return new DocumenttemplateCollectionRequest(contextPath.addSegment("lk_documenttemplatebase_organization"), Optional.empty());
    }

    public DocumenttemplateRequest lk_documenttemplatebase_organization(String documenttemplateid) {
        return new DocumenttemplateRequest(contextPath.addSegment("lk_documenttemplatebase_organization").addKeys(new NameValue(documenttemplateid.toString())), Optional.empty());
    }

    public QueueitemCollectionRequest organization_queueitems() {
        return new QueueitemCollectionRequest(contextPath.addSegment("organization_queueitems"), Optional.empty());
    }

    public QueueitemRequest organization_queueitems(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("organization_queueitems").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public ComplexcontrolCollectionRequest organization_complexcontrols() {
        return new ComplexcontrolCollectionRequest(contextPath.addSegment("organization_complexcontrols"), Optional.empty());
    }

    public ComplexcontrolRequest organization_complexcontrols(String complexcontrolid) {
        return new ComplexcontrolRequest(contextPath.addSegment("organization_complexcontrols").addKeys(new NameValue(complexcontrolid.toString())), Optional.empty());
    }

    public SolutionCollectionRequest organization_solution() {
        return new SolutionCollectionRequest(contextPath.addSegment("organization_solution"), Optional.empty());
    }

    public SolutionRequest organization_solution(String solutionid) {
        return new SolutionRequest(contextPath.addSegment("organization_solution").addKeys(new NameValue(solutionid.toString())), Optional.empty());
    }

    public BusinessunitCollectionRequest organization_business_units() {
        return new BusinessunitCollectionRequest(contextPath.addSegment("organization_business_units"), Optional.empty());
    }

    public BusinessunitRequest organization_business_units(String businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("organization_business_units").addKeys(new NameValue(businessunitid.toString())), Optional.empty());
    }

    public MobileofflineprofileCollectionRequest mobileOfflineProfile_organization() {
        return new MobileofflineprofileCollectionRequest(contextPath.addSegment("MobileOfflineProfile_organization"), Optional.empty());
    }

    public MobileofflineprofileRequest mobileOfflineProfile_organization(String mobileofflineprofileid) {
        return new MobileofflineprofileRequest(contextPath.addSegment("MobileOfflineProfile_organization").addKeys(new NameValue(mobileofflineprofileid.toString())), Optional.empty());
    }

    public SdkmessageprocessingstepimageCollectionRequest organization_sdkmessageprocessingstepimage() {
        return new SdkmessageprocessingstepimageCollectionRequest(contextPath.addSegment("organization_sdkmessageprocessingstepimage"), Optional.empty());
    }

    public SdkmessageprocessingstepimageRequest organization_sdkmessageprocessingstepimage(String sdkmessageprocessingstepimageid) {
        return new SdkmessageprocessingstepimageRequest(contextPath.addSegment("organization_sdkmessageprocessingstepimage").addKeys(new NameValue(sdkmessageprocessingstepimageid.toString())), Optional.empty());
    }

    public CustomcontrolCollectionRequest customcontrol_organization() {
        return new CustomcontrolCollectionRequest(contextPath.addSegment("customcontrol_organization"), Optional.empty());
    }

    public CustomcontrolRequest customcontrol_organization(String customcontrolid) {
        return new CustomcontrolRequest(contextPath.addSegment("customcontrol_organization").addKeys(new NameValue(customcontrolid.toString())), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigCollectionRequest organization_sdkmessageprocessingstepsecureconfig() {
        return new SdkmessageprocessingstepsecureconfigCollectionRequest(contextPath.addSegment("organization_sdkmessageprocessingstepsecureconfig"), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigRequest organization_sdkmessageprocessingstepsecureconfig(String sdkmessageprocessingstepsecureconfigid) {
        return new SdkmessageprocessingstepsecureconfigRequest(contextPath.addSegment("organization_sdkmessageprocessingstepsecureconfig").addKeys(new NameValue(sdkmessageprocessingstepsecureconfigid.toString())), Optional.empty());
    }

    public RoleCollectionRequest organization_roles() {
        return new RoleCollectionRequest(contextPath.addSegment("organization_roles"), Optional.empty());
    }

    public RoleRequest organization_roles(String roleid) {
        return new RoleRequest(contextPath.addSegment("organization_roles").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

    public AppconfigmasterCollectionRequest organization_appconfigmaster() {
        return new AppconfigmasterCollectionRequest(contextPath.addSegment("organization_appconfigmaster"), Optional.empty());
    }

    public AppconfigmasterRequest organization_appconfigmaster(String appconfigmasterid) {
        return new AppconfigmasterRequest(contextPath.addSegment("organization_appconfigmaster").addKeys(new NameValue(appconfigmasterid.toString())), Optional.empty());
    }

    public MobileofflineprofileitemassociationCollectionRequest mobileOfflineProfileItemAssociation_organization() {
        return new MobileofflineprofileitemassociationCollectionRequest(contextPath.addSegment("MobileOfflineProfileItemAssociation_organization"), Optional.empty());
    }

    public MobileofflineprofileitemassociationRequest mobileOfflineProfileItemAssociation_organization(String mobileofflineprofileitemassociationid) {
        return new MobileofflineprofileitemassociationRequest(contextPath.addSegment("MobileOfflineProfileItemAssociation_organization").addKeys(new NameValue(mobileofflineprofileitemassociationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest organization_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("Organization_MailboxTrackingFolder"), Optional.empty());
    }

    public MailboxtrackingfolderRequest organization_MailboxTrackingFolder(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("Organization_MailboxTrackingFolder").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest organization_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Organization_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest organization_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Organization_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public TranslationprocessCollectionRequest organization_translationprocess() {
        return new TranslationprocessCollectionRequest(contextPath.addSegment("organization_translationprocess"), Optional.empty());
    }

    public TranslationprocessRequest organization_translationprocess(String businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("organization_translationprocess").addKeys(new NameValue(businessprocessflowinstanceid.toString())), Optional.empty());
    }

    public TracelogCollectionRequest organization_tracelog() {
        return new TracelogCollectionRequest(contextPath.addSegment("organization_tracelog"), Optional.empty());
    }

    public TracelogRequest organization_tracelog(String tracelogid) {
        return new TracelogRequest(contextPath.addSegment("organization_tracelog").addKeys(new NameValue(tracelogid.toString())), Optional.empty());
    }

    public SystemformCollectionRequest organization_systemforms() {
        return new SystemformCollectionRequest(contextPath.addSegment("organization_systemforms"), Optional.empty());
    }

    public SystemformRequest organization_systemforms(String formid) {
        return new SystemformRequest(contextPath.addSegment("organization_systemforms").addKeys(new NameValue(formid.toString())), Optional.empty());
    }

    public BusinessunitnewsarticleCollectionRequest organization_business_unit_news_articles() {
        return new BusinessunitnewsarticleCollectionRequest(contextPath.addSegment("organization_business_unit_news_articles"), Optional.empty());
    }

    public BusinessunitnewsarticleRequest organization_business_unit_news_articles(String businessunitnewsarticleid) {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("organization_business_unit_news_articles").addKeys(new NameValue(businessunitnewsarticleid.toString())), Optional.empty());
    }

    public KbarticleCollectionRequest organization_kb_articles() {
        return new KbarticleCollectionRequest(contextPath.addSegment("organization_kb_articles"), Optional.empty());
    }

    public KbarticleRequest organization_kb_articles(String kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("organization_kb_articles").addKeys(new NameValue(kbarticleid.toString())), Optional.empty());
    }

    public SdkmessageCollectionRequest organization_sdkmessage() {
        return new SdkmessageCollectionRequest(contextPath.addSegment("organization_sdkmessage"), Optional.empty());
    }

    public SdkmessageRequest organization_sdkmessage(String sdkmessageid) {
        return new SdkmessageRequest(contextPath.addSegment("organization_sdkmessage").addKeys(new NameValue(sdkmessageid.toString())), Optional.empty());
    }

    public MobileofflineprofileitemCollectionRequest mobileOfflineProfileItem_organization() {
        return new MobileofflineprofileitemCollectionRequest(contextPath.addSegment("MobileOfflineProfileItem_organization"), Optional.empty());
    }

    public MobileofflineprofileitemRequest mobileOfflineProfileItem_organization(String mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("MobileOfflineProfileItem_organization").addKeys(new NameValue(mobileofflineprofileitemid.toString())), Optional.empty());
    }

    public KbarticletemplateCollectionRequest organization_kb_article_templates() {
        return new KbarticletemplateCollectionRequest(contextPath.addSegment("organization_kb_article_templates"), Optional.empty());
    }

    public KbarticletemplateRequest organization_kb_article_templates(String kbarticletemplateid) {
        return new KbarticletemplateRequest(contextPath.addSegment("organization_kb_article_templates").addKeys(new NameValue(kbarticletemplateid.toString())), Optional.empty());
    }

    public CustomcontrolresourceCollectionRequest customcontrolresource_organization() {
        return new CustomcontrolresourceCollectionRequest(contextPath.addSegment("customcontrolresource_organization"), Optional.empty());
    }

    public CustomcontrolresourceRequest customcontrolresource_organization(String customcontrolresourceid) {
        return new CustomcontrolresourceRequest(contextPath.addSegment("customcontrolresource_organization").addKeys(new NameValue(customcontrolresourceid.toString())), Optional.empty());
    }

    public MailboxCollectionRequest organization_mailbox() {
        return new MailboxCollectionRequest(contextPath.addSegment("organization_mailbox"), Optional.empty());
    }

    public MailboxRequest organization_mailbox(String mailboxid) {
        return new MailboxRequest(contextPath.addSegment("organization_mailbox").addKeys(new NameValue(mailboxid.toString())), Optional.empty());
    }

    public CalendarCollectionRequest organization_calendars() {
        return new CalendarCollectionRequest(contextPath.addSegment("organization_calendars"), Optional.empty());
    }

    public CalendarRequest organization_calendars(String calendarid) {
        return new CalendarRequest(contextPath.addSegment("organization_calendars").addKeys(new NameValue(calendarid.toString())), Optional.empty());
    }

    public WebwizardCollectionRequest organization_webwizard() {
        return new WebwizardCollectionRequest(contextPath.addSegment("organization_webwizard"), Optional.empty());
    }

    public WebwizardRequest organization_webwizard(String webwizardid) {
        return new WebwizardRequest(contextPath.addSegment("organization_webwizard").addKeys(new NameValue(webwizardid.toString())), Optional.empty());
    }

    public ConnectionroleCollectionRequest organization_connection_roles() {
        return new ConnectionroleCollectionRequest(contextPath.addSegment("organization_connection_roles"), Optional.empty());
    }

    public ConnectionroleRequest organization_connection_roles(String connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("organization_connection_roles").addKeys(new NameValue(connectionroleid.toString())), Optional.empty());
    }

    public CustomcontroldefaultconfigCollectionRequest customcontroldefaultconfig_organization() {
        return new CustomcontroldefaultconfigCollectionRequest(contextPath.addSegment("customcontroldefaultconfig_organization"), Optional.empty());
    }

    public CustomcontroldefaultconfigRequest customcontroldefaultconfig_organization(String customcontroldefaultconfigid) {
        return new CustomcontroldefaultconfigRequest(contextPath.addSegment("customcontroldefaultconfig_organization").addKeys(new NameValue(customcontroldefaultconfigid.toString())), Optional.empty());
    }

    public TransactioncurrencyCollectionRequest organization_transactioncurrencies() {
        return new TransactioncurrencyCollectionRequest(contextPath.addSegment("organization_transactioncurrencies"), Optional.empty());
    }

    public TransactioncurrencyRequest organization_transactioncurrencies(String transactioncurrencyid) {
        return new TransactioncurrencyRequest(contextPath.addSegment("organization_transactioncurrencies").addKeys(new NameValue(transactioncurrencyid.toString())), Optional.empty());
    }

    public NewprocessCollectionRequest organization_newprocess() {
        return new NewprocessCollectionRequest(contextPath.addSegment("organization_newprocess"), Optional.empty());
    }

    public NewprocessRequest organization_newprocess(String businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("organization_newprocess").addKeys(new NameValue(businessprocessflowinstanceid.toString())), Optional.empty());
    }

    public AciviewmapperCollectionRequest organization_aciviewmapper() {
        return new AciviewmapperCollectionRequest(contextPath.addSegment("organization_aciviewmapper"), Optional.empty());
    }

    public AciviewmapperRequest organization_aciviewmapper(String aciviewmapperid) {
        return new AciviewmapperRequest(contextPath.addSegment("organization_aciviewmapper").addKeys(new NameValue(aciviewmapperid.toString())), Optional.empty());
    }

    public LanguagelocaleCollectionRequest languagelocale_organization() {
        return new LanguagelocaleCollectionRequest(contextPath.addSegment("languagelocale_organization"), Optional.empty());
    }

    public LanguagelocaleRequest languagelocale_organization(String languagelocaleid) {
        return new LanguagelocaleRequest(contextPath.addSegment("languagelocale_organization").addKeys(new NameValue(languagelocaleid.toString())), Optional.empty());
    }

    public AppconfigCollectionRequest organization_appconfig() {
        return new AppconfigCollectionRequest(contextPath.addSegment("organization_appconfig"), Optional.empty());
    }

    public AppconfigRequest organization_appconfig(String appconfigid) {
        return new AppconfigRequest(contextPath.addSegment("organization_appconfig").addKeys(new NameValue(appconfigid.toString())), Optional.empty());
    }

    public AppmoduleCollectionRequest organization_appmodule() {
        return new AppmoduleCollectionRequest(contextPath.addSegment("organization_appmodule"), Optional.empty());
    }

    public AppmoduleRequest organization_appmodule(String appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("organization_appmodule").addKeys(new NameValue(appmoduleid.toString())), Optional.empty());
    }

    public NavigationsettingCollectionRequest organization_navigationsetting() {
        return new NavigationsettingCollectionRequest(contextPath.addSegment("organization_navigationsetting"), Optional.empty());
    }

    public NavigationsettingRequest organization_navigationsetting(String navigationsettingid) {
        return new NavigationsettingRequest(contextPath.addSegment("organization_navigationsetting").addKeys(new NameValue(navigationsettingid.toString())), Optional.empty());
    }

    public SubjectCollectionRequest organization_subjects() {
        return new SubjectCollectionRequest(contextPath.addSegment("organization_subjects"), Optional.empty());
    }

    public SubjectRequest organization_subjects(String subjectid) {
        return new SubjectRequest(contextPath.addSegment("organization_subjects").addKeys(new NameValue(subjectid.toString())), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationCollectionRequest organization_solutioncomponentattributeconfiguration() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(contextPath.addSegment("organization_solutioncomponentattributeconfiguration"), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationRequest organization_solutioncomponentattributeconfiguration(String solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("organization_solutioncomponentattributeconfiguration").addKeys(new NameValue(solutioncomponentattributeconfigurationid.toString())), Optional.empty());
    }

    public SolutioncomponentconfigurationCollectionRequest organization_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationCollectionRequest(contextPath.addSegment("organization_solutioncomponentconfiguration"), Optional.empty());
    }

    public SolutioncomponentconfigurationRequest organization_solutioncomponentconfiguration(String solutioncomponentconfigurationid) {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("organization_solutioncomponentconfiguration").addKeys(new NameValue(solutioncomponentconfigurationid.toString())), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationCollectionRequest organization_solutioncomponentrelationshipconfiguration() {
        return new SolutioncomponentrelationshipconfigurationCollectionRequest(contextPath.addSegment("organization_solutioncomponentrelationshipconfiguration"), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationRequest organization_solutioncomponentrelationshipconfiguration(String solutioncomponentrelationshipconfigurationid) {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("organization_solutioncomponentrelationshipconfiguration").addKeys(new NameValue(solutioncomponentrelationshipconfigurationid.toString())), Optional.empty());
    }

    public EntityanalyticsconfigCollectionRequest organization_entityanalyticsconfig() {
        return new EntityanalyticsconfigCollectionRequest(contextPath.addSegment("organization_entityanalyticsconfig"), Optional.empty());
    }

    public EntityanalyticsconfigRequest organization_entityanalyticsconfig(String entityanalyticsconfigid) {
        return new EntityanalyticsconfigRequest(contextPath.addSegment("organization_entityanalyticsconfig").addKeys(new NameValue(entityanalyticsconfigid.toString())), Optional.empty());
    }

    public DatalakeworkspaceCollectionRequest organization_datalakeworkspace() {
        return new DatalakeworkspaceCollectionRequest(contextPath.addSegment("organization_datalakeworkspace"), Optional.empty());
    }

    public DatalakeworkspaceRequest organization_datalakeworkspace(String datalakeworkspaceid) {
        return new DatalakeworkspaceRequest(contextPath.addSegment("organization_datalakeworkspace").addKeys(new NameValue(datalakeworkspaceid.toString())), Optional.empty());
    }

    public DatalakeworkspacepermissionCollectionRequest organization_datalakeworkspacepermission() {
        return new DatalakeworkspacepermissionCollectionRequest(contextPath.addSegment("organization_datalakeworkspacepermission"), Optional.empty());
    }

    public DatalakeworkspacepermissionRequest organization_datalakeworkspacepermission(String datalakeworkspacepermissionid) {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("organization_datalakeworkspacepermission").addKeys(new NameValue(datalakeworkspacepermissionid.toString())), Optional.empty());
    }

    public Msdyn_helppageCollectionRequest organization_msdyn_helppage() {
        return new Msdyn_helppageCollectionRequest(contextPath.addSegment("organization_msdyn_helppage"), Optional.empty());
    }

    public Msdyn_helppageRequest organization_msdyn_helppage(String msdyn_helppageid) {
        return new Msdyn_helppageRequest(contextPath.addSegment("organization_msdyn_helppage").addKeys(new NameValue(msdyn_helppageid.toString())), Optional.empty());
    }

    public TerritoryCollectionRequest organization_territories() {
        return new TerritoryCollectionRequest(contextPath.addSegment("organization_territories"), Optional.empty());
    }

    public TerritoryRequest organization_territories(String territoryid) {
        return new TerritoryRequest(contextPath.addSegment("organization_territories").addKeys(new NameValue(territoryid.toString())), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetCollectionRequest organization_msdyn_solutionhealthruleset() {
        return new Msdyn_solutionhealthrulesetCollectionRequest(contextPath.addSegment("organization_msdyn_solutionhealthruleset"), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetRequest organization_msdyn_solutionhealthruleset(String msdyn_solutionhealthrulesetid) {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("organization_msdyn_solutionhealthruleset").addKeys(new NameValue(msdyn_solutionhealthrulesetid.toString())), Optional.empty());
    }

}
