package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Navigationsetting;
import microsoft.dynamics.crm.entity.request.NavigationsettingRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class NavigationsettingCollectionRequest extends CollectionPageEntityRequest<Navigationsetting, NavigationsettingRequest>{

    protected ContextPath contextPath;

    public NavigationsettingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Navigationsetting.class, cp -> new NavigationsettingRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    @Function(name = "RetrieveUnpublishedMultiple")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Navigationsetting> retrieveUnpublishedMultiple() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublishedMultiple"), Navigationsetting.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

}
