package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Msdyn_aiodlabel;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingboundingboxRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class Msdyn_aiodlabelCollectionRequest extends CollectionPageEntityRequest<Msdyn_aiodlabel, Msdyn_aiodlabelRequest>{

    protected ContextPath contextPath;

    public Msdyn_aiodlabelCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_aiodlabel.class, cp -> new Msdyn_aiodlabelRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest msdyn_aiodlabel_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest msdyn_aiodlabel_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aiodlabel_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aiodlabel_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aiodlabel_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aiodlabel_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aiodlabel_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aiodlabel_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aiodlabel_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aiodlabel_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aiodlabel_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aiodlabel_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aiodlabel_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aiodlabel_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aiodlabel_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aiodlabel_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aiodlabel_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aiodlabel_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aiodlabel_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aiodlabel_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aiodlabel_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aiodlabel_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aiodlabel_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aiodlabel_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest msdyn_aiodlabel_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest msdyn_aiodlabel_msdyn_aiconfiguration(String msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_aiodlabel_msdyn_aiconfiguration").addKeys(new NameValue(msdyn_aiconfigurationid.toString())), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxCollectionRequest msdyn_aiodlabel_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(contextPath.addSegment("msdyn_aiodlabel_msdyn_aiodtrainingboundingbox"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest msdyn_aiodlabel_msdyn_aiodtrainingboundingbox(String msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("msdyn_aiodlabel_msdyn_aiodtrainingboundingbox").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid.toString())), Optional.empty());
    }

}
