package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Msdyn_aibfile;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class Msdyn_aibfileCollectionRequest extends CollectionPageEntityRequest<Msdyn_aibfile, Msdyn_aibfileRequest>{

    protected ContextPath contextPath;

    public Msdyn_aibfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_aibfile.class, cp -> new Msdyn_aibfileRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest msdyn_aibfile_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_aibfile_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest msdyn_aibfile_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aibfile_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibfile_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aibfile_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibfile_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibfile_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibfile_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aibfile_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibfile_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibfile_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aibfile_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_aibfile_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aibfile_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aibfile_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aibfile_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_aibfile_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aibfile_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aibfile_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aibfile_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_aibfile_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aibfile_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aibfile_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aibfile_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_aibfile_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aibfile_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aibfile_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aibfile_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_aibfile_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aibfile_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aibfile_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public FileattachmentCollectionRequest msdyn_aibfile_FileAttachments() {
        return new FileattachmentCollectionRequest(contextPath.addSegment("msdyn_aibfile_FileAttachments"), Optional.empty());
    }

    public FileattachmentRequest msdyn_aibfile_FileAttachments(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("msdyn_aibfile_FileAttachments").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

    public Msdyn_aibdatasetfileCollectionRequest msdyn_AIBDatasetFile_msdyn_AIBuilde() {
        return new Msdyn_aibdatasetfileCollectionRequest(contextPath.addSegment("msdyn_AIBDatasetFile_msdyn_AIBuilde"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest msdyn_AIBDatasetFile_msdyn_AIBuilde(String msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("msdyn_AIBDatasetFile_msdyn_AIBuilde").addKeys(new NameValue(msdyn_aibdatasetfileid.toString())), Optional.empty());
    }

}
