package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Metric;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.MetricRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.RollupfieldRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class MetricCollectionRequest extends CollectionPageEntityRequest<Metric, MetricRequest>{

    protected ContextPath contextPath;

    public MetricCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Metric.class, cp -> new MetricRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public GoalCollectionRequest metric_goal() {
        return new GoalCollectionRequest(contextPath.addSegment("metric_goal"), Optional.empty());
    }

    public GoalRequest metric_goal(String goalid) {
        return new GoalRequest(contextPath.addSegment("metric_goal").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public RollupfieldCollectionRequest metric_rollupfield() {
        return new RollupfieldCollectionRequest(contextPath.addSegment("metric_rollupfield"), Optional.empty());
    }

    public RollupfieldRequest metric_rollupfield(String rollupfieldid) {
        return new RollupfieldRequest(contextPath.addSegment("metric_rollupfield").addKeys(new NameValue(rollupfieldid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest metric_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("metric_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest metric_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("metric_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest metric_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("metric_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest metric_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("metric_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest metric_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Metric_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest metric_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Metric_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
