package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.ManyToManyRelationshipMetadata;
import microsoft.dynamics.crm.entity.request.ManyToManyRelationshipMetadataRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class ManyToManyRelationshipMetadataCollectionRequest extends CollectionPageEntityRequest<ManyToManyRelationshipMetadata, ManyToManyRelationshipMetadataRequest>{

    protected ContextPath contextPath;

    public ManyToManyRelationshipMetadataCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManyToManyRelationshipMetadata.class, cp -> new ManyToManyRelationshipMetadataRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
