package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.ManagedPropertyMetadata;
import microsoft.dynamics.crm.entity.request.ManagedPropertyMetadataRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class ManagedPropertyMetadataCollectionRequest extends CollectionPageEntityRequest<ManagedPropertyMetadata, ManagedPropertyMetadataRequest>{

    protected ContextPath contextPath;

    public ManagedPropertyMetadataCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagedPropertyMetadata.class, cp -> new ManagedPropertyMetadataRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
