package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Fieldsecurityprofile;
import microsoft.dynamics.crm.entity.request.FieldpermissionRequest;
import microsoft.dynamics.crm.entity.request.FieldsecurityprofileRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class FieldsecurityprofileCollectionRequest extends CollectionPageEntityRequest<Fieldsecurityprofile, FieldsecurityprofileRequest>{

    protected ContextPath contextPath;

    public FieldsecurityprofileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Fieldsecurityprofile.class, cp -> new FieldsecurityprofileRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest fieldSecurityProfile_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("FieldSecurityProfile_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest fieldSecurityProfile_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("FieldSecurityProfile_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest systemuserprofiles_association() {
        return new SystemuserCollectionRequest(contextPath.addSegment("systemuserprofiles_association"), Optional.empty());
    }

    public SystemuserRequest systemuserprofiles_association(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("systemuserprofiles_association").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public FieldpermissionCollectionRequest lk_fieldpermission_fieldsecurityprofileid() {
        return new FieldpermissionCollectionRequest(contextPath.addSegment("lk_fieldpermission_fieldsecurityprofileid"), Optional.empty());
    }

    public FieldpermissionRequest lk_fieldpermission_fieldsecurityprofileid(String fieldpermissionid) {
        return new FieldpermissionRequest(contextPath.addSegment("lk_fieldpermission_fieldsecurityprofileid").addKeys(new NameValue(fieldpermissionid.toString())), Optional.empty());
    }

    public TeamCollectionRequest teamprofiles_association() {
        return new TeamCollectionRequest(contextPath.addSegment("teamprofiles_association"), Optional.empty());
    }

    public TeamRequest teamprofiles_association(String ownerid) {
        return new TeamRequest(contextPath.addSegment("teamprofiles_association").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

}
