package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Fieldpermission;
import microsoft.dynamics.crm.entity.request.FieldpermissionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class FieldpermissionCollectionRequest extends CollectionPageEntityRequest<Fieldpermission, FieldpermissionRequest>{

    protected ContextPath contextPath;

    public FieldpermissionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Fieldpermission.class, cp -> new FieldpermissionRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest fieldPermission_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("FieldPermission_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest fieldPermission_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("FieldPermission_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
