package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Expiredprocess;
import microsoft.dynamics.crm.entity.request.ExpiredprocessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.WorkflowlogRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class ExpiredprocessCollectionRequest extends CollectionPageEntityRequest<Expiredprocess, ExpiredprocessRequest>{

    protected ContextPath contextPath;

    public ExpiredprocessCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Expiredprocess.class, cp -> new ExpiredprocessRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest expiredProcess_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ExpiredProcess_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest expiredProcess_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ExpiredProcess_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest expiredProcess_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("ExpiredProcess_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest expiredProcess_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("ExpiredProcess_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public WorkflowlogCollectionRequest workflowlogs_expiredprocess() {
        return new WorkflowlogCollectionRequest(contextPath.addSegment("workflowlogs_expiredprocess"), Optional.empty());
    }

    public WorkflowlogRequest workflowlogs_expiredprocess(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("workflowlogs_expiredprocess").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

}
