package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Entity;
import microsoft.dynamics.crm.entity.request.EntityRequest;
import microsoft.dynamics.crm.entity.request.EntityanalyticsconfigRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentconfigurationRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class EntityCollectionRequest extends CollectionPageEntityRequest<Entity, EntityRequest>{

    protected ContextPath contextPath;

    public EntityCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Entity.class, cp -> new EntityRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SolutioncomponentconfigurationCollectionRequest entity_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationCollectionRequest(contextPath.addSegment("entity_solutioncomponentconfiguration"), Optional.empty());
    }

    public SolutioncomponentconfigurationRequest entity_solutioncomponentconfiguration(String solutioncomponentconfigurationid) {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("entity_solutioncomponentconfiguration").addKeys(new NameValue(solutioncomponentconfigurationid.toString())), Optional.empty());
    }

    public EntityanalyticsconfigCollectionRequest entity_entityanalyticsconfig() {
        return new EntityanalyticsconfigCollectionRequest(contextPath.addSegment("entity_entityanalyticsconfig"), Optional.empty());
    }

    public EntityanalyticsconfigRequest entity_entityanalyticsconfig(String entityanalyticsconfigid) {
        return new EntityanalyticsconfigRequest(contextPath.addSegment("entity_entityanalyticsconfig").addKeys(new NameValue(entityanalyticsconfigid.toString())), Optional.empty());
    }

}
