package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Attachment;
import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Email;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActivitymimeattachmentRequest;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class EmailCollectionRequest extends CollectionPageEntityRequest<Email, EmailRequest>{

    protected ContextPath contextPath;

    public EmailCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Email.class, cp -> new EmailRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest email_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Email_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest email_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Email_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest email_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Email_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest email_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Email_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest email_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Email_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest email_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Email_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest email_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("email_connections1"), Optional.empty());
    }

    public ConnectionRequest email_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("email_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ActivitymimeattachmentCollectionRequest email_activity_mime_attachment() {
        return new ActivitymimeattachmentCollectionRequest(contextPath.addSegment("email_activity_mime_attachment"), Optional.empty());
    }

    public ActivitymimeattachmentRequest email_activity_mime_attachment(String activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("email_activity_mime_attachment").addKeys(new NameValue(activitymimeattachmentid.toString())), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_email() {
        return new SlakpiinstanceCollectionRequest(contextPath.addSegment("slakpiinstance_email"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_email(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_email").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest email_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("email_connections2"), Optional.empty());
    }

    public ConnectionRequest email_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("email_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest email_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("Email_Annotation"), Optional.empty());
    }

    public AnnotationRequest email_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Email_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest email_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Email_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest email_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Email_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest email_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Email_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest email_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Email_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ActivitypartyCollectionRequest email_activity_parties() {
        return new ActivitypartyCollectionRequest(contextPath.addSegment("email_activity_parties"), Optional.empty());
    }

    public ActivitypartyRequest email_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("email_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public ActioncardCollectionRequest email_actioncard() {
        return new ActioncardCollectionRequest(contextPath.addSegment("email_actioncard"), Optional.empty());
    }

    public ActioncardRequest email_actioncard(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("email_actioncard").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest email_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Email_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest email_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Email_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest email_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("email_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest email_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("email_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public QueueitemCollectionRequest email_QueueItem() {
        return new QueueitemCollectionRequest(contextPath.addSegment("Email_QueueItem"), Optional.empty());
    }

    public QueueitemRequest email_QueueItem(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("Email_QueueItem").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public EmailCollectionRequest email_email_parentactivityid() {
        return new EmailCollectionRequest(contextPath.addSegment("email_email_parentactivityid"), Optional.empty());
    }

    public EmailRequest email_email_parentactivityid(String activityid) {
        return new EmailRequest(contextPath.addSegment("email_email_parentactivityid").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    @Action(name = "DeliverIncomingEmail")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Email> deliverIncomingEmail(String messageId, String subject, String from, String to, String cc, String bcc, OffsetDateTime receivedOn, String submittedBy, String importance, String body, List<Attachment> attachments, Crmbaseentity extraProperties, Boolean validateBeforeCreate) {
        Preconditions.checkNotNull(messageId, "messageId cannot be null");
        Preconditions.checkNotNull(from, "from cannot be null");
        Preconditions.checkNotNull(to, "to cannot be null");
        Preconditions.checkNotNull(cc, "cc cannot be null");
        Preconditions.checkNotNull(bcc, "bcc cannot be null");
        Preconditions.checkNotNull(receivedOn, "receivedOn cannot be null");
        Preconditions.checkNotNull(submittedBy, "submittedBy cannot be null");
        Preconditions.checkNotNull(importance, "importance cannot be null");
        Preconditions.checkNotNull(body, "body cannot be null");
        Preconditions.checkNotNull(attachments, "attachments cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MessageId", "Edm.String", Checks.checkIsAscii(messageId))
            .put("Subject", "Edm.String", Checks.checkIsAscii(subject))
            .put("From", "Edm.String", Checks.checkIsAscii(from))
            .put("To", "Edm.String", Checks.checkIsAscii(to))
            .put("Cc", "Edm.String", Checks.checkIsAscii(cc))
            .put("Bcc", "Edm.String", Checks.checkIsAscii(bcc))
            .put("ReceivedOn", "Edm.DateTimeOffset", receivedOn)
            .put("SubmittedBy", "Edm.String", Checks.checkIsAscii(submittedBy))
            .put("Importance", "Edm.String", Checks.checkIsAscii(importance))
            .put("Body", "Edm.String", Checks.checkIsAscii(body))
            .put("Attachments", "Collection(Microsoft.Dynamics.CRM.attachment)", attachments)
            .put("ExtraProperties", "Microsoft.Dynamics.CRM.crmbaseentity", extraProperties)
            .put("ValidateBeforeCreate", "Edm.Boolean", validateBeforeCreate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Email>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeliverIncomingEmail"), Email.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

}
