package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Duplicaterulecondition;
import microsoft.dynamics.crm.entity.request.DuplicateruleconditionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class DuplicateruleconditionCollectionRequest extends CollectionPageEntityRequest<Duplicaterulecondition, DuplicateruleconditionRequest>{

    protected ContextPath contextPath;

    public DuplicateruleconditionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Duplicaterulecondition.class, cp -> new DuplicateruleconditionRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest duplicateRuleCondition_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("DuplicateRuleCondition_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest duplicateRuleCondition_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("DuplicateRuleCondition_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
