package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Connectionreference;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionreferenceRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class ConnectionreferenceCollectionRequest extends CollectionPageEntityRequest<Connectionreference, ConnectionreferenceRequest>{

    protected ContextPath contextPath;

    public ConnectionreferenceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Connectionreference.class, cp -> new ConnectionreferenceRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest connectionreference_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("connectionreference_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest connectionreference_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("connectionreference_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest connectionreference_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("connectionreference_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest connectionreference_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("connectionreference_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest connectionreference_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("connectionreference_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest connectionreference_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("connectionreference_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest connectionreference_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("connectionreference_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest connectionreference_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("connectionreference_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest connectionreference_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("connectionreference_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest connectionreference_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("connectionreference_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest connectionreference_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("connectionreference_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest connectionreference_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("connectionreference_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

}
