package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Connection;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class ConnectionCollectionRequest extends CollectionPageEntityRequest<Connection, ConnectionRequest>{

    protected ContextPath contextPath;

    public ConnectionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Connection.class, cp -> new ConnectionRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public PrincipalobjectattributeaccessCollectionRequest connection_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("connection_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest connection_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("connection_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest connection_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Connection_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest connection_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Connection_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest connection_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Connection_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest connection_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Connection_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest connection_related_connection() {
        return new ConnectionCollectionRequest(contextPath.addSegment("connection_related_connection"), Optional.empty());
    }

    public ConnectionRequest connection_related_connection(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("connection_related_connection").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest connection_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Connection_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest connection_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Connection_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
