package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Columnmapping;
import microsoft.dynamics.crm.entity.request.ColumnmappingRequest;
import microsoft.dynamics.crm.entity.request.LookupmappingRequest;
import microsoft.dynamics.crm.entity.request.PicklistmappingRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class ColumnmappingCollectionRequest extends CollectionPageEntityRequest<Columnmapping, ColumnmappingRequest>{

    protected ContextPath contextPath;

    public ColumnmappingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Columnmapping.class, cp -> new ColumnmappingRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public PicklistmappingCollectionRequest pickListMapping_ColumnMapping() {
        return new PicklistmappingCollectionRequest(contextPath.addSegment("PickListMapping_ColumnMapping"), Optional.empty());
    }

    public PicklistmappingRequest pickListMapping_ColumnMapping(String picklistmappingid) {
        return new PicklistmappingRequest(contextPath.addSegment("PickListMapping_ColumnMapping").addKeys(new NameValue(picklistmappingid.toString())), Optional.empty());
    }

    public LookupmappingCollectionRequest lookUpMapping_ColumnMapping() {
        return new LookupmappingCollectionRequest(contextPath.addSegment("LookUpMapping_ColumnMapping"), Optional.empty());
    }

    public LookupmappingRequest lookUpMapping_ColumnMapping(String lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("LookUpMapping_ColumnMapping").addKeys(new NameValue(lookupmappingid.toString())), Optional.empty());
    }

}
