package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Category;
import microsoft.dynamics.crm.entity.request.CategoryRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class CategoryCollectionRequest extends CollectionPageEntityRequest<Category, CategoryRequest>{

    protected ContextPath contextPath;

    public CategoryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Category.class, cp -> new CategoryRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public CategoryCollectionRequest category_parent_category() {
        return new CategoryCollectionRequest(contextPath.addSegment("category_parent_category"), Optional.empty());
    }

    public CategoryRequest category_parent_category(String categoryid) {
        return new CategoryRequest(contextPath.addSegment("category_parent_category").addKeys(new NameValue(categoryid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest category_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Category_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest category_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Category_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public KnowledgearticleCollectionRequest knowledgearticle_category() {
        return new KnowledgearticleCollectionRequest(contextPath.addSegment("knowledgearticle_category"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticle_category(String knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticle_category").addKeys(new NameValue(knowledgearticleid.toString())), Optional.empty());
    }

}
