package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Callbackregistration;
import microsoft.dynamics.crm.entity.request.CallbackregistrationRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class CallbackregistrationCollectionRequest extends CollectionPageEntityRequest<Callbackregistration, CallbackregistrationRequest>{

    protected ContextPath contextPath;

    public CallbackregistrationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Callbackregistration.class, cp -> new CallbackregistrationRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

}
