package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Bulkdeleteoperation;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.BulkdeleteoperationRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class BulkdeleteoperationCollectionRequest extends CollectionPageEntityRequest<Bulkdeleteoperation, BulkdeleteoperationRequest>{

    protected ContextPath contextPath;

    public BulkdeleteoperationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Bulkdeleteoperation.class, cp -> new BulkdeleteoperationRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public BulkdeletefailureCollectionRequest bulkDeleteOperation_BulkDeleteFailure() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("BulkDeleteOperation_BulkDeleteFailure"), Optional.empty());
    }

    public BulkdeletefailureRequest bulkDeleteOperation_BulkDeleteFailure(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("BulkDeleteOperation_BulkDeleteFailure").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

}
