package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Attribute;
import microsoft.dynamics.crm.entity.request.AttributeRequest;
import microsoft.dynamics.crm.entity.request.RelationshipattributeRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentattributeconfigurationRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class AttributeCollectionRequest extends CollectionPageEntityRequest<Attribute, AttributeRequest>{

    protected ContextPath contextPath;

    public AttributeCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Attribute.class, cp -> new AttributeRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SolutioncomponentattributeconfigurationCollectionRequest attribute_solutioncomponentattrconfig() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(contextPath.addSegment("attribute_solutioncomponentattrconfig"), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationRequest attribute_solutioncomponentattrconfig(String solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("attribute_solutioncomponentattrconfig").addKeys(new NameValue(solutioncomponentattributeconfigurationid.toString())), Optional.empty());
    }

    public RelationshipattributeCollectionRequest referencingdattribute_relationshipattribute() {
        return new RelationshipattributeCollectionRequest(contextPath.addSegment("referencingdattribute_relationshipattribute"), Optional.empty());
    }

    public RelationshipattributeRequest referencingdattribute_relationshipattribute(String relationshipattributeid) {
        return new RelationshipattributeRequest(contextPath.addSegment("referencingdattribute_relationshipattribute").addKeys(new NameValue(relationshipattributeid.toString())), Optional.empty());
    }

    public RelationshipattributeCollectionRequest referencedattribute_relationshipattribute() {
        return new RelationshipattributeCollectionRequest(contextPath.addSegment("referencedattribute_relationshipattribute"), Optional.empty());
    }

    public RelationshipattributeRequest referencedattribute_relationshipattribute(String relationshipattributeid) {
        return new RelationshipattributeRequest(contextPath.addSegment("referencedattribute_relationshipattribute").addKeys(new NameValue(relationshipattributeid.toString())), Optional.empty());
    }

}
