package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Applicationuser;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class ApplicationuserCollectionRequest extends CollectionPageEntityRequest<Applicationuser, ApplicationuserRequest>{

    protected ContextPath contextPath;

    public ApplicationuserCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Applicationuser.class, cp -> new ApplicationuserRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest applicationuser_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("applicationuser_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest applicationuser_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("applicationuser_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest applicationuser_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("applicationuser_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest applicationuser_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("applicationuser_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest applicationuser_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("applicationuser_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest applicationuser_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("applicationuser_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest applicationuser_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("applicationuser_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest applicationuser_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("applicationuser_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest applicationuser_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("applicationuser_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest applicationuser_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("applicationuser_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest applicationuser_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("applicationuser_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest applicationuser_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("applicationuser_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest applicationuser_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("applicationuser_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest applicationuser_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("applicationuser_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest applicationuser_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("applicationuser_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest applicationuser_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("applicationuser_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public RoleCollectionRequest applicationuserrole() {
        return new RoleCollectionRequest(contextPath.addSegment("applicationuserrole"), Optional.empty());
    }

    public RoleRequest applicationuserrole(String roleid) {
        return new RoleRequest(contextPath.addSegment("applicationuserrole").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

}
