package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Annualfiscalcalendar;
import microsoft.dynamics.crm.entity.request.AnnualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class AnnualfiscalcalendarCollectionRequest extends CollectionPageEntityRequest<Annualfiscalcalendar, AnnualfiscalcalendarRequest>{

    protected ContextPath contextPath;

    public AnnualfiscalcalendarCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Annualfiscalcalendar.class, cp -> new AnnualfiscalcalendarRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public BulkdeletefailureCollectionRequest annualFiscalCalendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("AnnualFiscalCalendar_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest annualFiscalCalendar_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("AnnualFiscalCalendar_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest annualFiscalCalendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("AnnualFiscalCalendar_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest annualFiscalCalendar_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("AnnualFiscalCalendar_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

}
