package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Account;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.CustomeraddressRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class AccountCollectionRequest extends CollectionPageEntityRequest<Account, AccountRequest>{

    protected ContextPath contextPath;

    public AccountCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Account.class, cp -> new AccountRequest(cp, Optional.empty()), SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public PrincipalobjectattributeaccessCollectionRequest account_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("account_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest account_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("account_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public ActivitypointerCollectionRequest account_ActivityPointers() {
        return new ActivitypointerCollectionRequest(contextPath.addSegment("Account_ActivityPointers"), Optional.empty());
    }

    public ActivitypointerRequest account_ActivityPointers(String activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("Account_ActivityPointers").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest account_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Account_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest account_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Account_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public EmailCollectionRequest account_Email_SendersAccount() {
        return new EmailCollectionRequest(contextPath.addSegment("Account_Email_SendersAccount"), Optional.empty());
    }

    public EmailRequest account_Email_SendersAccount(String activityid) {
        return new EmailRequest(contextPath.addSegment("Account_Email_SendersAccount").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public EmailCollectionRequest account_Email_EmailSender() {
        return new EmailCollectionRequest(contextPath.addSegment("Account_Email_EmailSender"), Optional.empty());
    }

    public EmailRequest account_Email_EmailSender(String activityid) {
        return new EmailRequest(contextPath.addSegment("Account_Email_EmailSender").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest account_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("Account_Annotation"), Optional.empty());
    }

    public AnnotationRequest account_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Account_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest account_SharepointDocumentLocation() {
        return new SharepointdocumentlocationCollectionRequest(contextPath.addSegment("Account_SharepointDocumentLocation"), Optional.empty());
    }

    public SharepointdocumentlocationRequest account_SharepointDocumentLocation(String sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("Account_SharepointDocumentLocation").addKeys(new NameValue(sharepointdocumentlocationid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest account_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("account_connections2"), Optional.empty());
    }

    public ConnectionRequest account_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("account_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public PostfollowCollectionRequest account_PostFollows() {
        return new PostfollowCollectionRequest(contextPath.addSegment("account_PostFollows"), Optional.empty());
    }

    public PostfollowRequest account_PostFollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("account_PostFollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public PostregardingCollectionRequest account_PostRegardings() {
        return new PostregardingCollectionRequest(contextPath.addSegment("account_PostRegardings"), Optional.empty());
    }

    public PostregardingRequest account_PostRegardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("account_PostRegardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest account_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Account_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest account_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Account_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public FaxCollectionRequest account_Faxes() {
        return new FaxCollectionRequest(contextPath.addSegment("Account_Faxes"), Optional.empty());
    }

    public FaxRequest account_Faxes(String activityid) {
        return new FaxRequest(contextPath.addSegment("Account_Faxes").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AccountCollectionRequest account_master_account() {
        return new AccountCollectionRequest(contextPath.addSegment("account_master_account"), Optional.empty());
    }

    public AccountRequest account_master_account(String accountid) {
        return new AccountRequest(contextPath.addSegment("account_master_account").addKeys(new NameValue(accountid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest account_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Account_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest account_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Account_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest account_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Account_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest account_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Account_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest account_RecurringAppointmentMasters() {
        return new RecurringappointmentmasterCollectionRequest(contextPath.addSegment("Account_RecurringAppointmentMasters"), Optional.empty());
    }

    public RecurringappointmentmasterRequest account_RecurringAppointmentMasters(String activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("Account_RecurringAppointmentMasters").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public PhonecallCollectionRequest account_Phonecalls() {
        return new PhonecallCollectionRequest(contextPath.addSegment("Account_Phonecalls"), Optional.empty());
    }

    public PhonecallRequest account_Phonecalls(String activityid) {
        return new PhonecallRequest(contextPath.addSegment("Account_Phonecalls").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest account_SocialActivities() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("Account_SocialActivities"), Optional.empty());
    }

    public SocialactivityRequest account_SocialActivities(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("Account_SocialActivities").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest account_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("Account_MailboxTrackingFolder"), Optional.empty());
    }

    public MailboxtrackingfolderRequest account_MailboxTrackingFolder(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("Account_MailboxTrackingFolder").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest socialActivity_PostAuthorAccount_accounts() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("SocialActivity_PostAuthorAccount_accounts"), Optional.empty());
    }

    public SocialactivityRequest socialActivity_PostAuthorAccount_accounts(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("SocialActivity_PostAuthorAccount_accounts").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public CustomeraddressCollectionRequest account_CustomerAddress() {
        return new CustomeraddressCollectionRequest(contextPath.addSegment("Account_CustomerAddress"), Optional.empty());
    }

    public CustomeraddressRequest account_CustomerAddress(String customeraddressid) {
        return new CustomeraddressRequest(contextPath.addSegment("Account_CustomerAddress").addKeys(new NameValue(customeraddressid.toString())), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_account() {
        return new SlakpiinstanceCollectionRequest(contextPath.addSegment("slakpiinstance_account"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_account(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_account").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

    public TaskCollectionRequest account_Tasks() {
        return new TaskCollectionRequest(contextPath.addSegment("Account_Tasks"), Optional.empty());
    }

    public TaskRequest account_Tasks(String activityid) {
        return new TaskRequest(contextPath.addSegment("Account_Tasks").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest account_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Account_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest account_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Account_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest socialActivity_PostAuthor_accounts() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("SocialActivity_PostAuthor_accounts"), Optional.empty());
    }

    public SocialactivityRequest socialActivity_PostAuthor_accounts(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("SocialActivity_PostAuthor_accounts").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ContactCollectionRequest contact_customer_accounts() {
        return new ContactCollectionRequest(contextPath.addSegment("contact_customer_accounts"), Optional.empty());
    }

    public ContactRequest contact_customer_accounts(String contactid) {
        return new ContactRequest(contextPath.addSegment("contact_customer_accounts").addKeys(new NameValue(contactid.toString())), Optional.empty());
    }

    public AppointmentCollectionRequest account_Appointments() {
        return new AppointmentCollectionRequest(contextPath.addSegment("Account_Appointments"), Optional.empty());
    }

    public AppointmentRequest account_Appointments(String activityid) {
        return new AppointmentRequest(contextPath.addSegment("Account_Appointments").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public EmailCollectionRequest account_Emails() {
        return new EmailCollectionRequest(contextPath.addSegment("Account_Emails"), Optional.empty());
    }

    public EmailRequest account_Emails(String activityid) {
        return new EmailRequest(contextPath.addSegment("Account_Emails").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AccountCollectionRequest account_parent_account() {
        return new AccountCollectionRequest(contextPath.addSegment("account_parent_account"), Optional.empty());
    }

    public AccountRequest account_parent_account(String accountid) {
        return new AccountRequest(contextPath.addSegment("account_parent_account").addKeys(new NameValue(accountid.toString())), Optional.empty());
    }

    public SocialprofileCollectionRequest socialprofile_customer_accounts() {
        return new SocialprofileCollectionRequest(contextPath.addSegment("Socialprofile_customer_accounts"), Optional.empty());
    }

    public SocialprofileRequest socialprofile_customer_accounts(String socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("Socialprofile_customer_accounts").addKeys(new NameValue(socialprofileid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest account_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Account_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest account_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Account_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public ActivitypartyCollectionRequest account_activity_parties() {
        return new ActivitypartyCollectionRequest(contextPath.addSegment("account_activity_parties"), Optional.empty());
    }

    public ActivitypartyRequest account_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("account_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest account_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("account_connections1"), Optional.empty());
    }

    public ConnectionRequest account_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("account_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ActioncardCollectionRequest account_actioncard() {
        return new ActioncardCollectionRequest(contextPath.addSegment("account_actioncard"), Optional.empty());
    }

    public ActioncardRequest account_actioncard(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("account_actioncard").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public LetterCollectionRequest account_Letters() {
        return new LetterCollectionRequest(contextPath.addSegment("Account_Letters"), Optional.empty());
    }

    public LetterRequest account_Letters(String activityid) {
        return new LetterRequest(contextPath.addSegment("Account_Letters").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

}
