package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TimezonedefinitionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "daylightname", 
    "_modifiedby_value", 
    "modifiedon", 
    "timezonelocalizednameid", 
    "standardname", 
    "_modifiedonbehalfby_value", 
    "createdon", 
    "userinterfacename", 
    "_timezonedefinitionid_value", 
    "cultureid", 
    "_createdonbehalfby_value", 
    "versionnumber", 
    "_organizationid_value", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Timezonelocalizedname extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.timezonelocalizedname";
    }

    @JsonProperty("daylightname")
    protected String daylightname;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("timezonelocalizednameid")
    protected String timezonelocalizednameid;

    @JsonProperty("standardname")
    protected String standardname;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("userinterfacename")
    protected String userinterfacename;

    @JsonProperty("_timezonedefinitionid_value")
    protected String _timezonedefinitionid_value;

    @JsonProperty("cultureid")
    protected Integer cultureid;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    protected Timezonelocalizedname() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTimezonelocalizedname() {
        return new Builder();
    }

    public static final class Builder {
        private String daylightname;
        private String _modifiedby_value;
        private OffsetDateTime modifiedon;
        private String timezonelocalizednameid;
        private String standardname;
        private String _modifiedonbehalfby_value;
        private OffsetDateTime createdon;
        private String userinterfacename;
        private String _timezonedefinitionid_value;
        private Integer cultureid;
        private String _createdonbehalfby_value;
        private Long versionnumber;
        private String _organizationid_value;
        private String _createdby_value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder daylightname(String daylightname) {
            this.daylightname = daylightname;
            this.changedFields = changedFields.add("daylightname");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder timezonelocalizednameid(String timezonelocalizednameid) {
            this.timezonelocalizednameid = timezonelocalizednameid;
            this.changedFields = changedFields.add("timezonelocalizednameid");
            return this;
        }

        public Builder standardname(String standardname) {
            this.standardname = standardname;
            this.changedFields = changedFields.add("standardname");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder userinterfacename(String userinterfacename) {
            this.userinterfacename = userinterfacename;
            this.changedFields = changedFields.add("userinterfacename");
            return this;
        }

        public Builder _timezonedefinitionid_value(String _timezonedefinitionid_value) {
            this._timezonedefinitionid_value = _timezonedefinitionid_value;
            this.changedFields = changedFields.add("_timezonedefinitionid_value");
            return this;
        }

        public Builder cultureid(Integer cultureid) {
            this.cultureid = cultureid;
            this.changedFields = changedFields.add("cultureid");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Timezonelocalizedname build() {
            Timezonelocalizedname _x = new Timezonelocalizedname();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.timezonelocalizedname";
            _x.daylightname = daylightname;
            _x._modifiedby_value = _modifiedby_value;
            _x.modifiedon = modifiedon;
            _x.timezonelocalizednameid = timezonelocalizednameid;
            _x.standardname = standardname;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.createdon = createdon;
            _x.userinterfacename = userinterfacename;
            _x._timezonedefinitionid_value = _timezonedefinitionid_value;
            _x.cultureid = cultureid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.versionnumber = versionnumber;
            _x._organizationid_value = _organizationid_value;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && timezonelocalizednameid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(timezonelocalizednameid.toString()));
        }
    }

    @Property(name="daylightname")
    @JsonIgnore
    public Optional<String> getDaylightname() {
        return Optional.ofNullable(daylightname);
    }

    public Timezonelocalizedname withDaylightname(String daylightname) {
        Checks.checkIsAscii(daylightname);
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("daylightname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x.daylightname = daylightname;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Timezonelocalizedname with_modifiedby_value(String _modifiedby_value) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Timezonelocalizedname withModifiedon(OffsetDateTime modifiedon) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="timezonelocalizednameid")
    @JsonIgnore
    public Optional<String> getTimezonelocalizednameid() {
        return Optional.ofNullable(timezonelocalizednameid);
    }

    public Timezonelocalizedname withTimezonelocalizednameid(String timezonelocalizednameid) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("timezonelocalizednameid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x.timezonelocalizednameid = timezonelocalizednameid;
        return _x;
    }

    @Property(name="standardname")
    @JsonIgnore
    public Optional<String> getStandardname() {
        return Optional.ofNullable(standardname);
    }

    public Timezonelocalizedname withStandardname(String standardname) {
        Checks.checkIsAscii(standardname);
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("standardname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x.standardname = standardname;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Timezonelocalizedname with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Timezonelocalizedname withCreatedon(OffsetDateTime createdon) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="userinterfacename")
    @JsonIgnore
    public Optional<String> getUserinterfacename() {
        return Optional.ofNullable(userinterfacename);
    }

    public Timezonelocalizedname withUserinterfacename(String userinterfacename) {
        Checks.checkIsAscii(userinterfacename);
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("userinterfacename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x.userinterfacename = userinterfacename;
        return _x;
    }

    @Property(name="_timezonedefinitionid_value")
    @JsonIgnore
    public Optional<String> get_timezonedefinitionid_value() {
        return Optional.ofNullable(_timezonedefinitionid_value);
    }

    public Timezonelocalizedname with_timezonedefinitionid_value(String _timezonedefinitionid_value) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("_timezonedefinitionid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x._timezonedefinitionid_value = _timezonedefinitionid_value;
        return _x;
    }

    @Property(name="cultureid")
    @JsonIgnore
    public Optional<Integer> getCultureid() {
        return Optional.ofNullable(cultureid);
    }

    public Timezonelocalizedname withCultureid(Integer cultureid) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("cultureid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x.cultureid = cultureid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Timezonelocalizedname with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Timezonelocalizedname withVersionnumber(Long versionnumber) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Timezonelocalizedname with_organizationid_value(String _organizationid_value) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Timezonelocalizedname with_createdby_value(String _createdby_value) {
        Timezonelocalizedname _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonelocalizedname");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Timezonelocalizedname withUnmappedField(String name, String value) {
        Timezonelocalizedname _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="timezonedefinitionid")
    @JsonIgnore
    public TimezonedefinitionRequest getTimezonedefinitionid() {
        return new TimezonedefinitionRequest(contextPath.addSegment("timezonedefinitionid"), RequestHelper.getValue(unmappedFields, "timezonedefinitionid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Timezonelocalizedname patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Timezonelocalizedname _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Timezonelocalizedname put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Timezonelocalizedname _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Timezonelocalizedname _copy() {
        Timezonelocalizedname _x = new Timezonelocalizedname();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.daylightname = daylightname;
        _x._modifiedby_value = _modifiedby_value;
        _x.modifiedon = modifiedon;
        _x.timezonelocalizednameid = timezonelocalizednameid;
        _x.standardname = standardname;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.createdon = createdon;
        _x.userinterfacename = userinterfacename;
        _x._timezonedefinitionid_value = _timezonedefinitionid_value;
        _x.cultureid = cultureid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.versionnumber = versionnumber;
        _x._organizationid_value = _organizationid_value;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Timezonelocalizedname[");
        b.append("daylightname=");
        b.append(this.daylightname);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("timezonelocalizednameid=");
        b.append(this.timezonelocalizednameid);
        b.append(", ");
        b.append("standardname=");
        b.append(this.standardname);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("userinterfacename=");
        b.append(this.userinterfacename);
        b.append(", ");
        b.append("_timezonedefinitionid_value=");
        b.append(this._timezonedefinitionid_value);
        b.append(", ");
        b.append("cultureid=");
        b.append(this.cultureid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
