package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "objecttypecode", 
    "subscriptionid", 
    "objectid", 
    "syncstate", 
    "versionnumber"})
@JsonInclude(Include.NON_NULL)
public class Subscriptionsyncentryoffline extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.subscriptionsyncentryoffline";
    }

    @JsonProperty("objecttypecode")
    protected Integer objecttypecode;

    @JsonProperty("subscriptionid")
    protected String subscriptionid;

    @JsonProperty("objectid")
    protected String objectid;

    @JsonProperty("syncstate")
    protected Integer syncstate;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    protected Subscriptionsyncentryoffline() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSubscriptionsyncentryoffline() {
        return new Builder();
    }

    public static final class Builder {
        private Integer objecttypecode;
        private String subscriptionid;
        private String objectid;
        private Integer syncstate;
        private Long versionnumber;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder objecttypecode(Integer objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder subscriptionid(String subscriptionid) {
            this.subscriptionid = subscriptionid;
            this.changedFields = changedFields.add("subscriptionid");
            return this;
        }

        public Builder objectid(String objectid) {
            this.objectid = objectid;
            this.changedFields = changedFields.add("objectid");
            return this;
        }

        public Builder syncstate(Integer syncstate) {
            this.syncstate = syncstate;
            this.changedFields = changedFields.add("syncstate");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Subscriptionsyncentryoffline build() {
            Subscriptionsyncentryoffline _x = new Subscriptionsyncentryoffline();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.subscriptionsyncentryoffline";
            _x.objecttypecode = objecttypecode;
            _x.subscriptionid = subscriptionid;
            _x.objectid = objectid;
            _x.syncstate = syncstate;
            _x.versionnumber = versionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && subscriptionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(subscriptionid.toString()));
        }
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<Integer> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Subscriptionsyncentryoffline withObjecttypecode(Integer objecttypecode) {
        Subscriptionsyncentryoffline _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionsyncentryoffline");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="subscriptionid")
    @JsonIgnore
    public Optional<String> getSubscriptionid() {
        return Optional.ofNullable(subscriptionid);
    }

    public Subscriptionsyncentryoffline withSubscriptionid(String subscriptionid) {
        Subscriptionsyncentryoffline _x = _copy();
        _x.changedFields = changedFields.add("subscriptionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionsyncentryoffline");
        _x.subscriptionid = subscriptionid;
        return _x;
    }

    @Property(name="objectid")
    @JsonIgnore
    public Optional<String> getObjectid() {
        return Optional.ofNullable(objectid);
    }

    public Subscriptionsyncentryoffline withObjectid(String objectid) {
        Subscriptionsyncentryoffline _x = _copy();
        _x.changedFields = changedFields.add("objectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionsyncentryoffline");
        _x.objectid = objectid;
        return _x;
    }

    @Property(name="syncstate")
    @JsonIgnore
    public Optional<Integer> getSyncstate() {
        return Optional.ofNullable(syncstate);
    }

    public Subscriptionsyncentryoffline withSyncstate(Integer syncstate) {
        Subscriptionsyncentryoffline _x = _copy();
        _x.changedFields = changedFields.add("syncstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionsyncentryoffline");
        _x.syncstate = syncstate;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Subscriptionsyncentryoffline withVersionnumber(Long versionnumber) {
        Subscriptionsyncentryoffline _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionsyncentryoffline");
        _x.versionnumber = versionnumber;
        return _x;
    }

    public Subscriptionsyncentryoffline withUnmappedField(String name, String value) {
        Subscriptionsyncentryoffline _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subscriptionsyncentryoffline patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Subscriptionsyncentryoffline _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subscriptionsyncentryoffline put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Subscriptionsyncentryoffline _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Subscriptionsyncentryoffline _copy() {
        Subscriptionsyncentryoffline _x = new Subscriptionsyncentryoffline();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.objecttypecode = objecttypecode;
        _x.subscriptionid = subscriptionid;
        _x.objectid = objectid;
        _x.syncstate = syncstate;
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Subscriptionsyncentryoffline[");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("subscriptionid=");
        b.append(this.subscriptionid);
        b.append(", ");
        b.append("objectid=");
        b.append(this.objectid);
        b.append(", ");
        b.append("syncstate=");
        b.append(this.syncstate);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
