package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentCollectionRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdon", 
    "componenttype", 
    "rootcomponentbehavior", 
    "modifiedon", 
    "versionnumber", 
    "_modifiedonbehalfby_value", 
    "ismetadata", 
    "rootsolutioncomponentid", 
    "_createdonbehalfby_value", 
    "_createdby_value", 
    "_solutionid_value", 
    "_modifiedby_value", 
    "solutioncomponentid", 
    "objectid"})
@JsonInclude(Include.NON_NULL)
public class Solutioncomponent extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.solutioncomponent";
    }

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("componenttype")
    protected Integer componenttype;

    @JsonProperty("rootcomponentbehavior")
    protected Integer rootcomponentbehavior;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("ismetadata")
    protected Boolean ismetadata;

    @JsonProperty("rootsolutioncomponentid")
    protected String rootsolutioncomponentid;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_solutionid_value")
    protected String _solutionid_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("solutioncomponentid")
    protected String solutioncomponentid;

    @JsonProperty("objectid")
    protected String objectid;

    protected Solutioncomponent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSolutioncomponent() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime createdon;
        private Integer componenttype;
        private Integer rootcomponentbehavior;
        private OffsetDateTime modifiedon;
        private Long versionnumber;
        private String _modifiedonbehalfby_value;
        private Boolean ismetadata;
        private String rootsolutioncomponentid;
        private String _createdonbehalfby_value;
        private String _createdby_value;
        private String _solutionid_value;
        private String _modifiedby_value;
        private String solutioncomponentid;
        private String objectid;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder componenttype(Integer componenttype) {
            this.componenttype = componenttype;
            this.changedFields = changedFields.add("componenttype");
            return this;
        }

        public Builder rootcomponentbehavior(Integer rootcomponentbehavior) {
            this.rootcomponentbehavior = rootcomponentbehavior;
            this.changedFields = changedFields.add("rootcomponentbehavior");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder ismetadata(Boolean ismetadata) {
            this.ismetadata = ismetadata;
            this.changedFields = changedFields.add("ismetadata");
            return this;
        }

        public Builder rootsolutioncomponentid(String rootsolutioncomponentid) {
            this.rootsolutioncomponentid = rootsolutioncomponentid;
            this.changedFields = changedFields.add("rootsolutioncomponentid");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _solutionid_value(String _solutionid_value) {
            this._solutionid_value = _solutionid_value;
            this.changedFields = changedFields.add("_solutionid_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder solutioncomponentid(String solutioncomponentid) {
            this.solutioncomponentid = solutioncomponentid;
            this.changedFields = changedFields.add("solutioncomponentid");
            return this;
        }

        public Builder objectid(String objectid) {
            this.objectid = objectid;
            this.changedFields = changedFields.add("objectid");
            return this;
        }

        public Solutioncomponent build() {
            Solutioncomponent _x = new Solutioncomponent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.solutioncomponent";
            _x.createdon = createdon;
            _x.componenttype = componenttype;
            _x.rootcomponentbehavior = rootcomponentbehavior;
            _x.modifiedon = modifiedon;
            _x.versionnumber = versionnumber;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.ismetadata = ismetadata;
            _x.rootsolutioncomponentid = rootsolutioncomponentid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x._solutionid_value = _solutionid_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.solutioncomponentid = solutioncomponentid;
            _x.objectid = objectid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && solutioncomponentid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(solutioncomponentid.toString()));
        }
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Solutioncomponent withCreatedon(OffsetDateTime createdon) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="componenttype")
    @JsonIgnore
    public Optional<Integer> getComponenttype() {
        return Optional.ofNullable(componenttype);
    }

    public Solutioncomponent withComponenttype(Integer componenttype) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("componenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x.componenttype = componenttype;
        return _x;
    }

    @Property(name="rootcomponentbehavior")
    @JsonIgnore
    public Optional<Integer> getRootcomponentbehavior() {
        return Optional.ofNullable(rootcomponentbehavior);
    }

    public Solutioncomponent withRootcomponentbehavior(Integer rootcomponentbehavior) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("rootcomponentbehavior");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x.rootcomponentbehavior = rootcomponentbehavior;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Solutioncomponent withModifiedon(OffsetDateTime modifiedon) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Solutioncomponent withVersionnumber(Long versionnumber) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Solutioncomponent with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="ismetadata")
    @JsonIgnore
    public Optional<Boolean> getIsmetadata() {
        return Optional.ofNullable(ismetadata);
    }

    public Solutioncomponent withIsmetadata(Boolean ismetadata) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("ismetadata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x.ismetadata = ismetadata;
        return _x;
    }

    @Property(name="rootsolutioncomponentid")
    @JsonIgnore
    public Optional<String> getRootsolutioncomponentid() {
        return Optional.ofNullable(rootsolutioncomponentid);
    }

    public Solutioncomponent withRootsolutioncomponentid(String rootsolutioncomponentid) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("rootsolutioncomponentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x.rootsolutioncomponentid = rootsolutioncomponentid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Solutioncomponent with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Solutioncomponent with_createdby_value(String _createdby_value) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_solutionid_value")
    @JsonIgnore
    public Optional<String> get_solutionid_value() {
        return Optional.ofNullable(_solutionid_value);
    }

    public Solutioncomponent with_solutionid_value(String _solutionid_value) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("_solutionid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x._solutionid_value = _solutionid_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Solutioncomponent with_modifiedby_value(String _modifiedby_value) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="solutioncomponentid")
    @JsonIgnore
    public Optional<String> getSolutioncomponentid() {
        return Optional.ofNullable(solutioncomponentid);
    }

    public Solutioncomponent withSolutioncomponentid(String solutioncomponentid) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("solutioncomponentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x.solutioncomponentid = solutioncomponentid;
        return _x;
    }

    @Property(name="objectid")
    @JsonIgnore
    public Optional<String> getObjectid() {
        return Optional.ofNullable(objectid);
    }

    public Solutioncomponent withObjectid(String objectid) {
        Solutioncomponent _x = _copy();
        _x.changedFields = changedFields.add("objectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponent");
        _x.objectid = objectid;
        return _x;
    }

    public Solutioncomponent withUnmappedField(String name, String value) {
        Solutioncomponent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="solutionid")
    @JsonIgnore
    public SolutionRequest getSolutionid() {
        return new SolutionRequest(contextPath.addSegment("solutionid"), RequestHelper.getValue(unmappedFields, "solutionid"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="rootsolutioncomponentid_solutioncomponent")
    @JsonIgnore
    public SolutioncomponentRequest getRootsolutioncomponentid_solutioncomponent() {
        return new SolutioncomponentRequest(contextPath.addSegment("rootsolutioncomponentid_solutioncomponent"), RequestHelper.getValue(unmappedFields, "rootsolutioncomponentid_solutioncomponent"));
    }

    @NavigationProperty(name="solutioncomponent_parent_solutioncomponent")
    @JsonIgnore
    public SolutioncomponentCollectionRequest getSolutioncomponent_parent_solutioncomponent() {
        return new SolutioncomponentCollectionRequest(
                        contextPath.addSegment("solutioncomponent_parent_solutioncomponent"), RequestHelper.getValue(unmappedFields, "solutioncomponent_parent_solutioncomponent"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Solutioncomponent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Solutioncomponent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Solutioncomponent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Solutioncomponent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Solutioncomponent _copy() {
        Solutioncomponent _x = new Solutioncomponent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.createdon = createdon;
        _x.componenttype = componenttype;
        _x.rootcomponentbehavior = rootcomponentbehavior;
        _x.modifiedon = modifiedon;
        _x.versionnumber = versionnumber;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.ismetadata = ismetadata;
        _x.rootsolutioncomponentid = rootsolutioncomponentid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x._solutionid_value = _solutionid_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.solutioncomponentid = solutioncomponentid;
        _x.objectid = objectid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Solutioncomponent[");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("componenttype=");
        b.append(this.componenttype);
        b.append(", ");
        b.append("rootcomponentbehavior=");
        b.append(this.rootcomponentbehavior);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("ismetadata=");
        b.append(this.ismetadata);
        b.append(", ");
        b.append("rootsolutioncomponentid=");
        b.append(this.rootsolutioncomponentid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_solutionid_value=");
        b.append(this._solutionid_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("solutioncomponentid=");
        b.append(this.solutioncomponentid);
        b.append(", ");
        b.append("objectid=");
        b.append(this.objectid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
