package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "overwritetime", 
    "modifiedon", 
    "sitemapxml", 
    "sitemapnameunique", 
    "_createdby_value", 
    "createdon", 
    "_modifiedonbehalfby_value", 
    "versionnumber", 
    "_createdonbehalfby_value", 
    "sitemapidunique", 
    "_modifiedby_value", 
    "componentstate", 
    "isappaware", 
    "sitemapname", 
    "_organizationid_value", 
    "solutionid", 
    "sitemapid", 
    "ismanaged"})
@JsonInclude(Include.NON_NULL)
public class Sitemap extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.sitemap";
    }

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("sitemapxml")
    protected String sitemapxml;

    @JsonProperty("sitemapnameunique")
    protected String sitemapnameunique;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("sitemapidunique")
    protected String sitemapidunique;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("isappaware")
    protected Boolean isappaware;

    @JsonProperty("sitemapname")
    protected String sitemapname;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("sitemapid")
    protected String sitemapid;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    protected Sitemap() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSitemap() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime overwritetime;
        private OffsetDateTime modifiedon;
        private String sitemapxml;
        private String sitemapnameunique;
        private String _createdby_value;
        private OffsetDateTime createdon;
        private String _modifiedonbehalfby_value;
        private Long versionnumber;
        private String _createdonbehalfby_value;
        private String sitemapidunique;
        private String _modifiedby_value;
        private Integer componentstate;
        private Boolean isappaware;
        private String sitemapname;
        private String _organizationid_value;
        private String solutionid;
        private String sitemapid;
        private Boolean ismanaged;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder sitemapxml(String sitemapxml) {
            this.sitemapxml = sitemapxml;
            this.changedFields = changedFields.add("sitemapxml");
            return this;
        }

        public Builder sitemapnameunique(String sitemapnameunique) {
            this.sitemapnameunique = sitemapnameunique;
            this.changedFields = changedFields.add("sitemapnameunique");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder sitemapidunique(String sitemapidunique) {
            this.sitemapidunique = sitemapidunique;
            this.changedFields = changedFields.add("sitemapidunique");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder isappaware(Boolean isappaware) {
            this.isappaware = isappaware;
            this.changedFields = changedFields.add("isappaware");
            return this;
        }

        public Builder sitemapname(String sitemapname) {
            this.sitemapname = sitemapname;
            this.changedFields = changedFields.add("sitemapname");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder sitemapid(String sitemapid) {
            this.sitemapid = sitemapid;
            this.changedFields = changedFields.add("sitemapid");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Sitemap build() {
            Sitemap _x = new Sitemap();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.sitemap";
            _x.overwritetime = overwritetime;
            _x.modifiedon = modifiedon;
            _x.sitemapxml = sitemapxml;
            _x.sitemapnameunique = sitemapnameunique;
            _x._createdby_value = _createdby_value;
            _x.createdon = createdon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.versionnumber = versionnumber;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.sitemapidunique = sitemapidunique;
            _x._modifiedby_value = _modifiedby_value;
            _x.componentstate = componentstate;
            _x.isappaware = isappaware;
            _x.sitemapname = sitemapname;
            _x._organizationid_value = _organizationid_value;
            _x.solutionid = solutionid;
            _x.sitemapid = sitemapid;
            _x.ismanaged = ismanaged;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && sitemapid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(sitemapid.toString()));
        }
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Sitemap withOverwritetime(OffsetDateTime overwritetime) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Sitemap withModifiedon(OffsetDateTime modifiedon) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="sitemapxml")
    @JsonIgnore
    public Optional<String> getSitemapxml() {
        return Optional.ofNullable(sitemapxml);
    }

    public Sitemap withSitemapxml(String sitemapxml) {
        Checks.checkIsAscii(sitemapxml);
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("sitemapxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.sitemapxml = sitemapxml;
        return _x;
    }

    @Property(name="sitemapnameunique")
    @JsonIgnore
    public Optional<String> getSitemapnameunique() {
        return Optional.ofNullable(sitemapnameunique);
    }

    public Sitemap withSitemapnameunique(String sitemapnameunique) {
        Checks.checkIsAscii(sitemapnameunique);
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("sitemapnameunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.sitemapnameunique = sitemapnameunique;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Sitemap with_createdby_value(String _createdby_value) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Sitemap withCreatedon(OffsetDateTime createdon) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Sitemap with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Sitemap withVersionnumber(Long versionnumber) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Sitemap with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="sitemapidunique")
    @JsonIgnore
    public Optional<String> getSitemapidunique() {
        return Optional.ofNullable(sitemapidunique);
    }

    public Sitemap withSitemapidunique(String sitemapidunique) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("sitemapidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.sitemapidunique = sitemapidunique;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Sitemap with_modifiedby_value(String _modifiedby_value) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Sitemap withComponentstate(Integer componentstate) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="isappaware")
    @JsonIgnore
    public Optional<Boolean> getIsappaware() {
        return Optional.ofNullable(isappaware);
    }

    public Sitemap withIsappaware(Boolean isappaware) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("isappaware");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.isappaware = isappaware;
        return _x;
    }

    @Property(name="sitemapname")
    @JsonIgnore
    public Optional<String> getSitemapname() {
        return Optional.ofNullable(sitemapname);
    }

    public Sitemap withSitemapname(String sitemapname) {
        Checks.checkIsAscii(sitemapname);
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("sitemapname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.sitemapname = sitemapname;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Sitemap with_organizationid_value(String _organizationid_value) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Sitemap withSolutionid(String solutionid) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="sitemapid")
    @JsonIgnore
    public Optional<String> getSitemapid() {
        return Optional.ofNullable(sitemapid);
    }

    public Sitemap withSitemapid(String sitemapid) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("sitemapid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.sitemapid = sitemapid;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Sitemap withIsmanaged(Boolean ismanaged) {
        Sitemap _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sitemap");
        _x.ismanaged = ismanaged;
        return _x;
    }

    public Sitemap withUnmappedField(String name, String value) {
        Sitemap _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="SiteMap_modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getSiteMap_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("SiteMap_modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "SiteMap_modifiedonbehalfby"));
    }

    @NavigationProperty(name="SiteMap_modifiedby")
    @JsonIgnore
    public SystemuserRequest getSiteMap_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("SiteMap_modifiedby"), RequestHelper.getValue(unmappedFields, "SiteMap_modifiedby"));
    }

    @NavigationProperty(name="SiteMap_createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getSiteMap_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("SiteMap_createdonbehalfby"), RequestHelper.getValue(unmappedFields, "SiteMap_createdonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="SiteMap_createdby")
    @JsonIgnore
    public SystemuserRequest getSiteMap_createdby() {
        return new SystemuserRequest(contextPath.addSegment("SiteMap_createdby"), RequestHelper.getValue(unmappedFields, "SiteMap_createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sitemap patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Sitemap _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sitemap put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Sitemap _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Sitemap _copy() {
        Sitemap _x = new Sitemap();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.overwritetime = overwritetime;
        _x.modifiedon = modifiedon;
        _x.sitemapxml = sitemapxml;
        _x.sitemapnameunique = sitemapnameunique;
        _x._createdby_value = _createdby_value;
        _x.createdon = createdon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.versionnumber = versionnumber;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.sitemapidunique = sitemapidunique;
        _x._modifiedby_value = _modifiedby_value;
        _x.componentstate = componentstate;
        _x.isappaware = isappaware;
        _x.sitemapname = sitemapname;
        _x._organizationid_value = _organizationid_value;
        _x.solutionid = solutionid;
        _x.sitemapid = sitemapid;
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Sitemap> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Sitemap>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Sitemap.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Sitemap[");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("sitemapxml=");
        b.append(this.sitemapxml);
        b.append(", ");
        b.append("sitemapnameunique=");
        b.append(this.sitemapnameunique);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("sitemapidunique=");
        b.append(this.sitemapidunique);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("isappaware=");
        b.append(this.isappaware);
        b.append(", ");
        b.append("sitemapname=");
        b.append(this.sitemapname);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("sitemapid=");
        b.append(this.sitemapid);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
