package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "offlinesqlquery", 
    "ismanaged", 
    "solutionid", 
    "versionnumber", 
    "statecode", 
    "_createdby_value", 
    "isuserdefined", 
    "columnsetxml", 
    "organizationtaborder", 
    "isdefault", 
    "querytype", 
    "conditionalformatting", 
    "_modifiedby_value", 
    "queryapi", 
    "advancedgroupby", 
    "statuscode", 
    "isquickfindquery", 
    "_organizationid_value", 
    "description", 
    "fetchxml", 
    "createdon", 
    "savedqueryidunique", 
    "layoutxml", 
    "layoutjson", 
    "returnedtypecode", 
    "name", 
    "iscustomizable", 
    "queryappusage", 
    "componentstate", 
    "_modifiedonbehalfby_value", 
    "savedqueryid", 
    "overwritetime", 
    "introducedversion", 
    "iscustom", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "canbedeleted"})
@JsonInclude(Include.NON_NULL)
public class Savedquery extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.savedquery";
    }

    @JsonProperty("offlinesqlquery")
    protected String offlinesqlquery;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("isuserdefined")
    protected Boolean isuserdefined;

    @JsonProperty("columnsetxml")
    protected String columnsetxml;

    @JsonProperty("organizationtaborder")
    protected Integer organizationtaborder;

    @JsonProperty("isdefault")
    protected Boolean isdefault;

    @JsonProperty("querytype")
    protected Integer querytype;

    @JsonProperty("conditionalformatting")
    protected String conditionalformatting;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("queryapi")
    protected String queryapi;

    @JsonProperty("advancedgroupby")
    protected String advancedgroupby;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("isquickfindquery")
    protected Boolean isquickfindquery;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("fetchxml")
    protected String fetchxml;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("savedqueryidunique")
    protected String savedqueryidunique;

    @JsonProperty("layoutxml")
    protected String layoutxml;

    @JsonProperty("layoutjson")
    protected String layoutjson;

    @JsonProperty("returnedtypecode")
    protected String returnedtypecode;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("queryappusage")
    protected Integer queryappusage;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("savedqueryid")
    protected String savedqueryid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("iscustom")
    protected Boolean iscustom;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("canbedeleted")
    protected BooleanManagedProperty canbedeleted;

    protected Savedquery() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSavedquery() {
        return new Builder();
    }

    public static final class Builder {
        private String offlinesqlquery;
        private Boolean ismanaged;
        private String solutionid;
        private Long versionnumber;
        private Integer statecode;
        private String _createdby_value;
        private Boolean isuserdefined;
        private String columnsetxml;
        private Integer organizationtaborder;
        private Boolean isdefault;
        private Integer querytype;
        private String conditionalformatting;
        private String _modifiedby_value;
        private String queryapi;
        private String advancedgroupby;
        private Integer statuscode;
        private Boolean isquickfindquery;
        private String _organizationid_value;
        private String description;
        private String fetchxml;
        private OffsetDateTime createdon;
        private String savedqueryidunique;
        private String layoutxml;
        private String layoutjson;
        private String returnedtypecode;
        private String name;
        private BooleanManagedProperty iscustomizable;
        private Integer queryappusage;
        private Integer componentstate;
        private String _modifiedonbehalfby_value;
        private String savedqueryid;
        private OffsetDateTime overwritetime;
        private String introducedversion;
        private Boolean iscustom;
        private String _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private BooleanManagedProperty canbedeleted;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder offlinesqlquery(String offlinesqlquery) {
            this.offlinesqlquery = offlinesqlquery;
            this.changedFields = changedFields.add("offlinesqlquery");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder isuserdefined(Boolean isuserdefined) {
            this.isuserdefined = isuserdefined;
            this.changedFields = changedFields.add("isuserdefined");
            return this;
        }

        public Builder columnsetxml(String columnsetxml) {
            this.columnsetxml = columnsetxml;
            this.changedFields = changedFields.add("columnsetxml");
            return this;
        }

        public Builder organizationtaborder(Integer organizationtaborder) {
            this.organizationtaborder = organizationtaborder;
            this.changedFields = changedFields.add("organizationtaborder");
            return this;
        }

        public Builder isdefault(Boolean isdefault) {
            this.isdefault = isdefault;
            this.changedFields = changedFields.add("isdefault");
            return this;
        }

        public Builder querytype(Integer querytype) {
            this.querytype = querytype;
            this.changedFields = changedFields.add("querytype");
            return this;
        }

        public Builder conditionalformatting(String conditionalformatting) {
            this.conditionalformatting = conditionalformatting;
            this.changedFields = changedFields.add("conditionalformatting");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder queryapi(String queryapi) {
            this.queryapi = queryapi;
            this.changedFields = changedFields.add("queryapi");
            return this;
        }

        public Builder advancedgroupby(String advancedgroupby) {
            this.advancedgroupby = advancedgroupby;
            this.changedFields = changedFields.add("advancedgroupby");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder isquickfindquery(Boolean isquickfindquery) {
            this.isquickfindquery = isquickfindquery;
            this.changedFields = changedFields.add("isquickfindquery");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder fetchxml(String fetchxml) {
            this.fetchxml = fetchxml;
            this.changedFields = changedFields.add("fetchxml");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder savedqueryidunique(String savedqueryidunique) {
            this.savedqueryidunique = savedqueryidunique;
            this.changedFields = changedFields.add("savedqueryidunique");
            return this;
        }

        public Builder layoutxml(String layoutxml) {
            this.layoutxml = layoutxml;
            this.changedFields = changedFields.add("layoutxml");
            return this;
        }

        public Builder layoutjson(String layoutjson) {
            this.layoutjson = layoutjson;
            this.changedFields = changedFields.add("layoutjson");
            return this;
        }

        public Builder returnedtypecode(String returnedtypecode) {
            this.returnedtypecode = returnedtypecode;
            this.changedFields = changedFields.add("returnedtypecode");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder queryappusage(Integer queryappusage) {
            this.queryappusage = queryappusage;
            this.changedFields = changedFields.add("queryappusage");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder savedqueryid(String savedqueryid) {
            this.savedqueryid = savedqueryid;
            this.changedFields = changedFields.add("savedqueryid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder iscustom(Boolean iscustom) {
            this.iscustom = iscustom;
            this.changedFields = changedFields.add("iscustom");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder canbedeleted(BooleanManagedProperty canbedeleted) {
            this.canbedeleted = canbedeleted;
            this.changedFields = changedFields.add("canbedeleted");
            return this;
        }

        public Savedquery build() {
            Savedquery _x = new Savedquery();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.savedquery";
            _x.offlinesqlquery = offlinesqlquery;
            _x.ismanaged = ismanaged;
            _x.solutionid = solutionid;
            _x.versionnumber = versionnumber;
            _x.statecode = statecode;
            _x._createdby_value = _createdby_value;
            _x.isuserdefined = isuserdefined;
            _x.columnsetxml = columnsetxml;
            _x.organizationtaborder = organizationtaborder;
            _x.isdefault = isdefault;
            _x.querytype = querytype;
            _x.conditionalformatting = conditionalformatting;
            _x._modifiedby_value = _modifiedby_value;
            _x.queryapi = queryapi;
            _x.advancedgroupby = advancedgroupby;
            _x.statuscode = statuscode;
            _x.isquickfindquery = isquickfindquery;
            _x._organizationid_value = _organizationid_value;
            _x.description = description;
            _x.fetchxml = fetchxml;
            _x.createdon = createdon;
            _x.savedqueryidunique = savedqueryidunique;
            _x.layoutxml = layoutxml;
            _x.layoutjson = layoutjson;
            _x.returnedtypecode = returnedtypecode;
            _x.name = name;
            _x.iscustomizable = iscustomizable;
            _x.queryappusage = queryappusage;
            _x.componentstate = componentstate;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.savedqueryid = savedqueryid;
            _x.overwritetime = overwritetime;
            _x.introducedversion = introducedversion;
            _x.iscustom = iscustom;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.canbedeleted = canbedeleted;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && savedqueryid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(savedqueryid.toString()));
        }
    }

    @Property(name="offlinesqlquery")
    @JsonIgnore
    public Optional<String> getOfflinesqlquery() {
        return Optional.ofNullable(offlinesqlquery);
    }

    public Savedquery withOfflinesqlquery(String offlinesqlquery) {
        Checks.checkIsAscii(offlinesqlquery);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("offlinesqlquery");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.offlinesqlquery = offlinesqlquery;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Savedquery withIsmanaged(Boolean ismanaged) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Savedquery withSolutionid(String solutionid) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Savedquery withVersionnumber(Long versionnumber) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Savedquery withStatecode(Integer statecode) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Savedquery with_createdby_value(String _createdby_value) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="isuserdefined")
    @JsonIgnore
    public Optional<Boolean> getIsuserdefined() {
        return Optional.ofNullable(isuserdefined);
    }

    public Savedquery withIsuserdefined(Boolean isuserdefined) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("isuserdefined");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.isuserdefined = isuserdefined;
        return _x;
    }

    @Property(name="columnsetxml")
    @JsonIgnore
    public Optional<String> getColumnsetxml() {
        return Optional.ofNullable(columnsetxml);
    }

    public Savedquery withColumnsetxml(String columnsetxml) {
        Checks.checkIsAscii(columnsetxml);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("columnsetxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.columnsetxml = columnsetxml;
        return _x;
    }

    @Property(name="organizationtaborder")
    @JsonIgnore
    public Optional<Integer> getOrganizationtaborder() {
        return Optional.ofNullable(organizationtaborder);
    }

    public Savedquery withOrganizationtaborder(Integer organizationtaborder) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("organizationtaborder");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.organizationtaborder = organizationtaborder;
        return _x;
    }

    @Property(name="isdefault")
    @JsonIgnore
    public Optional<Boolean> getIsdefault() {
        return Optional.ofNullable(isdefault);
    }

    public Savedquery withIsdefault(Boolean isdefault) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("isdefault");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.isdefault = isdefault;
        return _x;
    }

    @Property(name="querytype")
    @JsonIgnore
    public Optional<Integer> getQuerytype() {
        return Optional.ofNullable(querytype);
    }

    public Savedquery withQuerytype(Integer querytype) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("querytype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.querytype = querytype;
        return _x;
    }

    @Property(name="conditionalformatting")
    @JsonIgnore
    public Optional<String> getConditionalformatting() {
        return Optional.ofNullable(conditionalformatting);
    }

    public Savedquery withConditionalformatting(String conditionalformatting) {
        Checks.checkIsAscii(conditionalformatting);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("conditionalformatting");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.conditionalformatting = conditionalformatting;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Savedquery with_modifiedby_value(String _modifiedby_value) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="queryapi")
    @JsonIgnore
    public Optional<String> getQueryapi() {
        return Optional.ofNullable(queryapi);
    }

    public Savedquery withQueryapi(String queryapi) {
        Checks.checkIsAscii(queryapi);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("queryapi");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.queryapi = queryapi;
        return _x;
    }

    @Property(name="advancedgroupby")
    @JsonIgnore
    public Optional<String> getAdvancedgroupby() {
        return Optional.ofNullable(advancedgroupby);
    }

    public Savedquery withAdvancedgroupby(String advancedgroupby) {
        Checks.checkIsAscii(advancedgroupby);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("advancedgroupby");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.advancedgroupby = advancedgroupby;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Savedquery withStatuscode(Integer statuscode) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="isquickfindquery")
    @JsonIgnore
    public Optional<Boolean> getIsquickfindquery() {
        return Optional.ofNullable(isquickfindquery);
    }

    public Savedquery withIsquickfindquery(Boolean isquickfindquery) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("isquickfindquery");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.isquickfindquery = isquickfindquery;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Savedquery with_organizationid_value(String _organizationid_value) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Savedquery withDescription(String description) {
        Checks.checkIsAscii(description);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.description = description;
        return _x;
    }

    @Property(name="fetchxml")
    @JsonIgnore
    public Optional<String> getFetchxml() {
        return Optional.ofNullable(fetchxml);
    }

    public Savedquery withFetchxml(String fetchxml) {
        Checks.checkIsAscii(fetchxml);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("fetchxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.fetchxml = fetchxml;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Savedquery withCreatedon(OffsetDateTime createdon) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="savedqueryidunique")
    @JsonIgnore
    public Optional<String> getSavedqueryidunique() {
        return Optional.ofNullable(savedqueryidunique);
    }

    public Savedquery withSavedqueryidunique(String savedqueryidunique) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("savedqueryidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.savedqueryidunique = savedqueryidunique;
        return _x;
    }

    @Property(name="layoutxml")
    @JsonIgnore
    public Optional<String> getLayoutxml() {
        return Optional.ofNullable(layoutxml);
    }

    public Savedquery withLayoutxml(String layoutxml) {
        Checks.checkIsAscii(layoutxml);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("layoutxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.layoutxml = layoutxml;
        return _x;
    }

    @Property(name="layoutjson")
    @JsonIgnore
    public Optional<String> getLayoutjson() {
        return Optional.ofNullable(layoutjson);
    }

    public Savedquery withLayoutjson(String layoutjson) {
        Checks.checkIsAscii(layoutjson);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("layoutjson");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.layoutjson = layoutjson;
        return _x;
    }

    @Property(name="returnedtypecode")
    @JsonIgnore
    public Optional<String> getReturnedtypecode() {
        return Optional.ofNullable(returnedtypecode);
    }

    public Savedquery withReturnedtypecode(String returnedtypecode) {
        Checks.checkIsAscii(returnedtypecode);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("returnedtypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.returnedtypecode = returnedtypecode;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Savedquery withName(String name) {
        Checks.checkIsAscii(name);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.name = name;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Savedquery withIscustomizable(BooleanManagedProperty iscustomizable) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="queryappusage")
    @JsonIgnore
    public Optional<Integer> getQueryappusage() {
        return Optional.ofNullable(queryappusage);
    }

    public Savedquery withQueryappusage(Integer queryappusage) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("queryappusage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.queryappusage = queryappusage;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Savedquery withComponentstate(Integer componentstate) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Savedquery with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="savedqueryid")
    @JsonIgnore
    public Optional<String> getSavedqueryid() {
        return Optional.ofNullable(savedqueryid);
    }

    public Savedquery withSavedqueryid(String savedqueryid) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("savedqueryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.savedqueryid = savedqueryid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Savedquery withOverwritetime(OffsetDateTime overwritetime) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Savedquery withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="iscustom")
    @JsonIgnore
    public Optional<Boolean> getIscustom() {
        return Optional.ofNullable(iscustom);
    }

    public Savedquery withIscustom(Boolean iscustom) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("iscustom");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.iscustom = iscustom;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Savedquery with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Savedquery withModifiedon(OffsetDateTime modifiedon) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="canbedeleted")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanbedeleted() {
        return Optional.ofNullable(canbedeleted);
    }

    public Savedquery withCanbedeleted(BooleanManagedProperty canbedeleted) {
        Savedquery _x = _copy();
        _x.changedFields = changedFields.add("canbedeleted");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.savedquery");
        _x.canbedeleted = canbedeleted;
        return _x;
    }

    public Savedquery withUnmappedField(String name, String value) {
        Savedquery _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="SavedQuery_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSavedQuery_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SavedQuery_SyncErrors"), RequestHelper.getValue(unmappedFields, "SavedQuery_SyncErrors"));
    }

    @NavigationProperty(name="SavedQuery_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getSavedQuery_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SavedQuery_AsyncOperations"), RequestHelper.getValue(unmappedFields, "SavedQuery_AsyncOperations"));
    }

    @NavigationProperty(name="SavedQuery_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getSavedQuery_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("SavedQuery_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "SavedQuery_BulkDeleteFailures"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="lk_mobileofflineprofileitem_savedquery")
    @JsonIgnore
    public MobileofflineprofileitemCollectionRequest getLk_mobileofflineprofileitem_savedquery() {
        return new MobileofflineprofileitemCollectionRequest(
                        contextPath.addSegment("lk_mobileofflineprofileitem_savedquery"), RequestHelper.getValue(unmappedFields, "lk_mobileofflineprofileitem_savedquery"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Savedquery patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Savedquery _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Savedquery put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Savedquery _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Savedquery _copy() {
        Savedquery _x = new Savedquery();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.offlinesqlquery = offlinesqlquery;
        _x.ismanaged = ismanaged;
        _x.solutionid = solutionid;
        _x.versionnumber = versionnumber;
        _x.statecode = statecode;
        _x._createdby_value = _createdby_value;
        _x.isuserdefined = isuserdefined;
        _x.columnsetxml = columnsetxml;
        _x.organizationtaborder = organizationtaborder;
        _x.isdefault = isdefault;
        _x.querytype = querytype;
        _x.conditionalformatting = conditionalformatting;
        _x._modifiedby_value = _modifiedby_value;
        _x.queryapi = queryapi;
        _x.advancedgroupby = advancedgroupby;
        _x.statuscode = statuscode;
        _x.isquickfindquery = isquickfindquery;
        _x._organizationid_value = _organizationid_value;
        _x.description = description;
        _x.fetchxml = fetchxml;
        _x.createdon = createdon;
        _x.savedqueryidunique = savedqueryidunique;
        _x.layoutxml = layoutxml;
        _x.layoutjson = layoutjson;
        _x.returnedtypecode = returnedtypecode;
        _x.name = name;
        _x.iscustomizable = iscustomizable;
        _x.queryappusage = queryappusage;
        _x.componentstate = componentstate;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.savedqueryid = savedqueryid;
        _x.overwritetime = overwritetime;
        _x.introducedversion = introducedversion;
        _x.iscustom = iscustom;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.canbedeleted = canbedeleted;
        return _x;
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Savedquery> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Savedquery>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Savedquery.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Savedquery[");
        b.append("offlinesqlquery=");
        b.append(this.offlinesqlquery);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("isuserdefined=");
        b.append(this.isuserdefined);
        b.append(", ");
        b.append("columnsetxml=");
        b.append(this.columnsetxml);
        b.append(", ");
        b.append("organizationtaborder=");
        b.append(this.organizationtaborder);
        b.append(", ");
        b.append("isdefault=");
        b.append(this.isdefault);
        b.append(", ");
        b.append("querytype=");
        b.append(this.querytype);
        b.append(", ");
        b.append("conditionalformatting=");
        b.append(this.conditionalformatting);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("queryapi=");
        b.append(this.queryapi);
        b.append(", ");
        b.append("advancedgroupby=");
        b.append(this.advancedgroupby);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("isquickfindquery=");
        b.append(this.isquickfindquery);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("fetchxml=");
        b.append(this.fetchxml);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("savedqueryidunique=");
        b.append(this.savedqueryidunique);
        b.append(", ");
        b.append("layoutxml=");
        b.append(this.layoutxml);
        b.append(", ");
        b.append("layoutjson=");
        b.append(this.layoutjson);
        b.append(", ");
        b.append("returnedtypecode=");
        b.append(this.returnedtypecode);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("queryappusage=");
        b.append(this.queryappusage);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("savedqueryid=");
        b.append(this.savedqueryid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("iscustom=");
        b.append(this.iscustom);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("canbedeleted=");
        b.append(this.canbedeleted);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
