package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;

@JsonPropertyOrder({
    "@odata.type", 
    "privilegeid", 
    "roleid", 
    "privilegedepthmask", 
    "ismanaged", 
    "canbedeleted", 
    "roleprivilegeidunique", 
    "roleprivilegeid", 
    "solutionid", 
    "versionnumber", 
    "componentstate", 
    "overwritetime"})
@JsonInclude(Include.NON_NULL)
public class Roleprivileges extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.roleprivileges";
    }

    @JsonProperty("privilegeid")
    protected String privilegeid;

    @JsonProperty("roleid")
    protected String roleid;

    @JsonProperty("privilegedepthmask")
    protected Integer privilegedepthmask;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("canbedeleted")
    protected BooleanManagedProperty canbedeleted;

    @JsonProperty("roleprivilegeidunique")
    protected String roleprivilegeidunique;

    @JsonProperty("roleprivilegeid")
    protected String roleprivilegeid;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    protected Roleprivileges() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoleprivileges() {
        return new Builder();
    }

    public static final class Builder {
        private String privilegeid;
        private String roleid;
        private Integer privilegedepthmask;
        private Boolean ismanaged;
        private BooleanManagedProperty canbedeleted;
        private String roleprivilegeidunique;
        private String roleprivilegeid;
        private String solutionid;
        private Long versionnumber;
        private Integer componentstate;
        private OffsetDateTime overwritetime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder privilegeid(String privilegeid) {
            this.privilegeid = privilegeid;
            this.changedFields = changedFields.add("privilegeid");
            return this;
        }

        public Builder roleid(String roleid) {
            this.roleid = roleid;
            this.changedFields = changedFields.add("roleid");
            return this;
        }

        public Builder privilegedepthmask(Integer privilegedepthmask) {
            this.privilegedepthmask = privilegedepthmask;
            this.changedFields = changedFields.add("privilegedepthmask");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder canbedeleted(BooleanManagedProperty canbedeleted) {
            this.canbedeleted = canbedeleted;
            this.changedFields = changedFields.add("canbedeleted");
            return this;
        }

        public Builder roleprivilegeidunique(String roleprivilegeidunique) {
            this.roleprivilegeidunique = roleprivilegeidunique;
            this.changedFields = changedFields.add("roleprivilegeidunique");
            return this;
        }

        public Builder roleprivilegeid(String roleprivilegeid) {
            this.roleprivilegeid = roleprivilegeid;
            this.changedFields = changedFields.add("roleprivilegeid");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Roleprivileges build() {
            Roleprivileges _x = new Roleprivileges();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.roleprivileges";
            _x.privilegeid = privilegeid;
            _x.roleid = roleid;
            _x.privilegedepthmask = privilegedepthmask;
            _x.ismanaged = ismanaged;
            _x.canbedeleted = canbedeleted;
            _x.roleprivilegeidunique = roleprivilegeidunique;
            _x.roleprivilegeid = roleprivilegeid;
            _x.solutionid = solutionid;
            _x.versionnumber = versionnumber;
            _x.componentstate = componentstate;
            _x.overwritetime = overwritetime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && roleprivilegeid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(roleprivilegeid.toString()));
        }
    }

    @Property(name="privilegeid")
    @JsonIgnore
    public Optional<String> getPrivilegeid() {
        return Optional.ofNullable(privilegeid);
    }

    public Roleprivileges withPrivilegeid(String privilegeid) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("privilegeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.privilegeid = privilegeid;
        return _x;
    }

    @Property(name="roleid")
    @JsonIgnore
    public Optional<String> getRoleid() {
        return Optional.ofNullable(roleid);
    }

    public Roleprivileges withRoleid(String roleid) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("roleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.roleid = roleid;
        return _x;
    }

    @Property(name="privilegedepthmask")
    @JsonIgnore
    public Optional<Integer> getPrivilegedepthmask() {
        return Optional.ofNullable(privilegedepthmask);
    }

    public Roleprivileges withPrivilegedepthmask(Integer privilegedepthmask) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("privilegedepthmask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.privilegedepthmask = privilegedepthmask;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Roleprivileges withIsmanaged(Boolean ismanaged) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="canbedeleted")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanbedeleted() {
        return Optional.ofNullable(canbedeleted);
    }

    public Roleprivileges withCanbedeleted(BooleanManagedProperty canbedeleted) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("canbedeleted");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.canbedeleted = canbedeleted;
        return _x;
    }

    @Property(name="roleprivilegeidunique")
    @JsonIgnore
    public Optional<String> getRoleprivilegeidunique() {
        return Optional.ofNullable(roleprivilegeidunique);
    }

    public Roleprivileges withRoleprivilegeidunique(String roleprivilegeidunique) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("roleprivilegeidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.roleprivilegeidunique = roleprivilegeidunique;
        return _x;
    }

    @Property(name="roleprivilegeid")
    @JsonIgnore
    public Optional<String> getRoleprivilegeid() {
        return Optional.ofNullable(roleprivilegeid);
    }

    public Roleprivileges withRoleprivilegeid(String roleprivilegeid) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("roleprivilegeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.roleprivilegeid = roleprivilegeid;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Roleprivileges withSolutionid(String solutionid) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Roleprivileges withVersionnumber(Long versionnumber) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Roleprivileges withComponentstate(Integer componentstate) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Roleprivileges withOverwritetime(OffsetDateTime overwritetime) {
        Roleprivileges _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roleprivileges");
        _x.overwritetime = overwritetime;
        return _x;
    }

    public Roleprivileges withUnmappedField(String name, String value) {
        Roleprivileges _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Roleprivileges patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Roleprivileges _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Roleprivileges put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Roleprivileges _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Roleprivileges _copy() {
        Roleprivileges _x = new Roleprivileges();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.privilegeid = privilegeid;
        _x.roleid = roleid;
        _x.privilegedepthmask = privilegedepthmask;
        _x.ismanaged = ismanaged;
        _x.canbedeleted = canbedeleted;
        _x.roleprivilegeidunique = roleprivilegeidunique;
        _x.roleprivilegeid = roleprivilegeid;
        _x.solutionid = solutionid;
        _x.versionnumber = versionnumber;
        _x.componentstate = componentstate;
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Roleprivileges[");
        b.append("privilegeid=");
        b.append(this.privilegeid);
        b.append(", ");
        b.append("roleid=");
        b.append(this.roleid);
        b.append(", ");
        b.append("privilegedepthmask=");
        b.append(this.privilegedepthmask);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("canbedeleted=");
        b.append(this.canbedeleted);
        b.append(", ");
        b.append("roleprivilegeidunique=");
        b.append(this.roleprivilegeidunique);
        b.append(", ");
        b.append("roleprivilegeid=");
        b.append(this.roleprivilegeid);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
