package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.ColumnmappingRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransformationparametermappingRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdon", 
    "modifiedon", 
    "_modifiedonbehalfby_value", 
    "solutionid", 
    "ismanaged", 
    "processcode", 
    "_columnmappingid_value", 
    "statecode", 
    "statuscode", 
    "lookupmappingid", 
    "_createdby_value", 
    "lookupattributename", 
    "_transformationparametermappingid_value", 
    "lookupentityname", 
    "_createdonbehalfby_value", 
    "_modifiedby_value", 
    "lookupsourcecode", 
    "introducedversion", 
    "componentstate", 
    "lookupmappingidunique", 
    "overwritetime"})
@JsonInclude(Include.NON_NULL)
public class Lookupmapping extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.lookupmapping";
    }

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("processcode")
    protected Integer processcode;

    @JsonProperty("_columnmappingid_value")
    protected String _columnmappingid_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("lookupmappingid")
    protected String lookupmappingid;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("lookupattributename")
    protected String lookupattributename;

    @JsonProperty("_transformationparametermappingid_value")
    protected String _transformationparametermappingid_value;

    @JsonProperty("lookupentityname")
    protected String lookupentityname;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("lookupsourcecode")
    protected Integer lookupsourcecode;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("lookupmappingidunique")
    protected String lookupmappingidunique;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    protected Lookupmapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLookupmapping() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime createdon;
        private OffsetDateTime modifiedon;
        private String _modifiedonbehalfby_value;
        private String solutionid;
        private Boolean ismanaged;
        private Integer processcode;
        private String _columnmappingid_value;
        private Integer statecode;
        private Integer statuscode;
        private String lookupmappingid;
        private String _createdby_value;
        private String lookupattributename;
        private String _transformationparametermappingid_value;
        private String lookupentityname;
        private String _createdonbehalfby_value;
        private String _modifiedby_value;
        private Integer lookupsourcecode;
        private String introducedversion;
        private Integer componentstate;
        private String lookupmappingidunique;
        private OffsetDateTime overwritetime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder processcode(Integer processcode) {
            this.processcode = processcode;
            this.changedFields = changedFields.add("processcode");
            return this;
        }

        public Builder _columnmappingid_value(String _columnmappingid_value) {
            this._columnmappingid_value = _columnmappingid_value;
            this.changedFields = changedFields.add("_columnmappingid_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder lookupmappingid(String lookupmappingid) {
            this.lookupmappingid = lookupmappingid;
            this.changedFields = changedFields.add("lookupmappingid");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder lookupattributename(String lookupattributename) {
            this.lookupattributename = lookupattributename;
            this.changedFields = changedFields.add("lookupattributename");
            return this;
        }

        public Builder _transformationparametermappingid_value(String _transformationparametermappingid_value) {
            this._transformationparametermappingid_value = _transformationparametermappingid_value;
            this.changedFields = changedFields.add("_transformationparametermappingid_value");
            return this;
        }

        public Builder lookupentityname(String lookupentityname) {
            this.lookupentityname = lookupentityname;
            this.changedFields = changedFields.add("lookupentityname");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder lookupsourcecode(Integer lookupsourcecode) {
            this.lookupsourcecode = lookupsourcecode;
            this.changedFields = changedFields.add("lookupsourcecode");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder lookupmappingidunique(String lookupmappingidunique) {
            this.lookupmappingidunique = lookupmappingidunique;
            this.changedFields = changedFields.add("lookupmappingidunique");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Lookupmapping build() {
            Lookupmapping _x = new Lookupmapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.lookupmapping";
            _x.createdon = createdon;
            _x.modifiedon = modifiedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.solutionid = solutionid;
            _x.ismanaged = ismanaged;
            _x.processcode = processcode;
            _x._columnmappingid_value = _columnmappingid_value;
            _x.statecode = statecode;
            _x.statuscode = statuscode;
            _x.lookupmappingid = lookupmappingid;
            _x._createdby_value = _createdby_value;
            _x.lookupattributename = lookupattributename;
            _x._transformationparametermappingid_value = _transformationparametermappingid_value;
            _x.lookupentityname = lookupentityname;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.lookupsourcecode = lookupsourcecode;
            _x.introducedversion = introducedversion;
            _x.componentstate = componentstate;
            _x.lookupmappingidunique = lookupmappingidunique;
            _x.overwritetime = overwritetime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && lookupmappingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(lookupmappingid.toString()));
        }
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Lookupmapping withCreatedon(OffsetDateTime createdon) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Lookupmapping withModifiedon(OffsetDateTime modifiedon) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Lookupmapping with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Lookupmapping withSolutionid(String solutionid) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Lookupmapping withIsmanaged(Boolean ismanaged) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="processcode")
    @JsonIgnore
    public Optional<Integer> getProcesscode() {
        return Optional.ofNullable(processcode);
    }

    public Lookupmapping withProcesscode(Integer processcode) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("processcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.processcode = processcode;
        return _x;
    }

    @Property(name="_columnmappingid_value")
    @JsonIgnore
    public Optional<String> get_columnmappingid_value() {
        return Optional.ofNullable(_columnmappingid_value);
    }

    public Lookupmapping with_columnmappingid_value(String _columnmappingid_value) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("_columnmappingid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x._columnmappingid_value = _columnmappingid_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Lookupmapping withStatecode(Integer statecode) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Lookupmapping withStatuscode(Integer statuscode) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="lookupmappingid")
    @JsonIgnore
    public Optional<String> getLookupmappingid() {
        return Optional.ofNullable(lookupmappingid);
    }

    public Lookupmapping withLookupmappingid(String lookupmappingid) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("lookupmappingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.lookupmappingid = lookupmappingid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Lookupmapping with_createdby_value(String _createdby_value) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="lookupattributename")
    @JsonIgnore
    public Optional<String> getLookupattributename() {
        return Optional.ofNullable(lookupattributename);
    }

    public Lookupmapping withLookupattributename(String lookupattributename) {
        Checks.checkIsAscii(lookupattributename);
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("lookupattributename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.lookupattributename = lookupattributename;
        return _x;
    }

    @Property(name="_transformationparametermappingid_value")
    @JsonIgnore
    public Optional<String> get_transformationparametermappingid_value() {
        return Optional.ofNullable(_transformationparametermappingid_value);
    }

    public Lookupmapping with_transformationparametermappingid_value(String _transformationparametermappingid_value) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("_transformationparametermappingid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x._transformationparametermappingid_value = _transformationparametermappingid_value;
        return _x;
    }

    @Property(name="lookupentityname")
    @JsonIgnore
    public Optional<String> getLookupentityname() {
        return Optional.ofNullable(lookupentityname);
    }

    public Lookupmapping withLookupentityname(String lookupentityname) {
        Checks.checkIsAscii(lookupentityname);
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("lookupentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.lookupentityname = lookupentityname;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Lookupmapping with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Lookupmapping with_modifiedby_value(String _modifiedby_value) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="lookupsourcecode")
    @JsonIgnore
    public Optional<Integer> getLookupsourcecode() {
        return Optional.ofNullable(lookupsourcecode);
    }

    public Lookupmapping withLookupsourcecode(Integer lookupsourcecode) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("lookupsourcecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.lookupsourcecode = lookupsourcecode;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Lookupmapping withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Lookupmapping withComponentstate(Integer componentstate) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="lookupmappingidunique")
    @JsonIgnore
    public Optional<String> getLookupmappingidunique() {
        return Optional.ofNullable(lookupmappingidunique);
    }

    public Lookupmapping withLookupmappingidunique(String lookupmappingidunique) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("lookupmappingidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.lookupmappingidunique = lookupmappingidunique;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Lookupmapping withOverwritetime(OffsetDateTime overwritetime) {
        Lookupmapping _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.lookupmapping");
        _x.overwritetime = overwritetime;
        return _x;
    }

    public Lookupmapping withUnmappedField(String name, String value) {
        Lookupmapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="transformationparametermappingid")
    @JsonIgnore
    public TransformationparametermappingRequest getTransformationparametermappingid() {
        return new TransformationparametermappingRequest(contextPath.addSegment("transformationparametermappingid"), RequestHelper.getValue(unmappedFields, "transformationparametermappingid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="columnmappingid")
    @JsonIgnore
    public ColumnmappingRequest getColumnmappingid() {
        return new ColumnmappingRequest(contextPath.addSegment("columnmappingid"), RequestHelper.getValue(unmappedFields, "columnmappingid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Lookupmapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Lookupmapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Lookupmapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Lookupmapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Lookupmapping _copy() {
        Lookupmapping _x = new Lookupmapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.createdon = createdon;
        _x.modifiedon = modifiedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.solutionid = solutionid;
        _x.ismanaged = ismanaged;
        _x.processcode = processcode;
        _x._columnmappingid_value = _columnmappingid_value;
        _x.statecode = statecode;
        _x.statuscode = statuscode;
        _x.lookupmappingid = lookupmappingid;
        _x._createdby_value = _createdby_value;
        _x.lookupattributename = lookupattributename;
        _x._transformationparametermappingid_value = _transformationparametermappingid_value;
        _x.lookupentityname = lookupentityname;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.lookupsourcecode = lookupsourcecode;
        _x.introducedversion = introducedversion;
        _x.componentstate = componentstate;
        _x.lookupmappingidunique = lookupmappingidunique;
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Lookupmapping[");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("processcode=");
        b.append(this.processcode);
        b.append(", ");
        b.append("_columnmappingid_value=");
        b.append(this._columnmappingid_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("lookupmappingid=");
        b.append(this.lookupmappingid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("lookupattributename=");
        b.append(this.lookupattributename);
        b.append(", ");
        b.append("_transformationparametermappingid_value=");
        b.append(this._transformationparametermappingid_value);
        b.append(", ");
        b.append("lookupentityname=");
        b.append(this.lookupentityname);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("lookupsourcecode=");
        b.append(this.lookupsourcecode);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("lookupmappingidunique=");
        b.append(this.lookupmappingidunique);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
