package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.ExportMappingsImportMapResponse;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ColumnmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportentitymappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OwnermappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TransformationmappingCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_owningbusinessunit_value", 
    "source", 
    "entitiesperfile", 
    "sourcetype", 
    "statecode", 
    "targetuseridentifierforsourcecrmuserlink", 
    "sourceuseridentifierforsourcedatasourceuserlink", 
    "importmapid", 
    "iswizardcreated", 
    "targetentity", 
    "importmapidunique", 
    "_ownerid_value", 
    "isvalidforimport", 
    "introducedversion", 
    "_createdonbehalfby_value", 
    "mapcustomizations", 
    "_createdby_value", 
    "_modifiedby_value", 
    "description", 
    "statuscode", 
    "ismanaged", 
    "name", 
    "overwritetime", 
    "sourceuseridentifierforsourcecrmuserlink", 
    "solutionid", 
    "_modifiedonbehalfby_value", 
    "importmaptype", 
    "_owninguser_value", 
    "modifiedon", 
    "componentstate", 
    "_owningteam_value", 
    "createdon"})
@JsonInclude(Include.NON_NULL)
public class Importmap extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.importmap";
    }

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("source")
    protected String source;

    @JsonProperty("entitiesperfile")
    protected Integer entitiesperfile;

    @JsonProperty("sourcetype")
    protected Integer sourcetype;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("targetuseridentifierforsourcecrmuserlink")
    protected String targetuseridentifierforsourcecrmuserlink;

    @JsonProperty("sourceuseridentifierforsourcedatasourceuserlink")
    protected String sourceuseridentifierforsourcedatasourceuserlink;

    @JsonProperty("importmapid")
    protected String importmapid;

    @JsonProperty("iswizardcreated")
    protected Boolean iswizardcreated;

    @JsonProperty("targetentity")
    protected Integer targetentity;

    @JsonProperty("importmapidunique")
    protected String importmapidunique;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("isvalidforimport")
    protected Boolean isvalidforimport;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("mapcustomizations")
    protected String mapcustomizations;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("sourceuseridentifierforsourcecrmuserlink")
    protected String sourceuseridentifierforsourcecrmuserlink;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("importmaptype")
    protected Integer importmaptype;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    protected Importmap() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportmap() {
        return new Builder();
    }

    public static final class Builder {
        private String _owningbusinessunit_value;
        private String source;
        private Integer entitiesperfile;
        private Integer sourcetype;
        private Integer statecode;
        private String targetuseridentifierforsourcecrmuserlink;
        private String sourceuseridentifierforsourcedatasourceuserlink;
        private String importmapid;
        private Boolean iswizardcreated;
        private Integer targetentity;
        private String importmapidunique;
        private String _ownerid_value;
        private Boolean isvalidforimport;
        private String introducedversion;
        private String _createdonbehalfby_value;
        private String mapcustomizations;
        private String _createdby_value;
        private String _modifiedby_value;
        private String description;
        private Integer statuscode;
        private Boolean ismanaged;
        private String name;
        private OffsetDateTime overwritetime;
        private String sourceuseridentifierforsourcecrmuserlink;
        private String solutionid;
        private String _modifiedonbehalfby_value;
        private Integer importmaptype;
        private String _owninguser_value;
        private OffsetDateTime modifiedon;
        private Integer componentstate;
        private String _owningteam_value;
        private OffsetDateTime createdon;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder entitiesperfile(Integer entitiesperfile) {
            this.entitiesperfile = entitiesperfile;
            this.changedFields = changedFields.add("entitiesperfile");
            return this;
        }

        public Builder sourcetype(Integer sourcetype) {
            this.sourcetype = sourcetype;
            this.changedFields = changedFields.add("sourcetype");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder targetuseridentifierforsourcecrmuserlink(String targetuseridentifierforsourcecrmuserlink) {
            this.targetuseridentifierforsourcecrmuserlink = targetuseridentifierforsourcecrmuserlink;
            this.changedFields = changedFields.add("targetuseridentifierforsourcecrmuserlink");
            return this;
        }

        public Builder sourceuseridentifierforsourcedatasourceuserlink(String sourceuseridentifierforsourcedatasourceuserlink) {
            this.sourceuseridentifierforsourcedatasourceuserlink = sourceuseridentifierforsourcedatasourceuserlink;
            this.changedFields = changedFields.add("sourceuseridentifierforsourcedatasourceuserlink");
            return this;
        }

        public Builder importmapid(String importmapid) {
            this.importmapid = importmapid;
            this.changedFields = changedFields.add("importmapid");
            return this;
        }

        public Builder iswizardcreated(Boolean iswizardcreated) {
            this.iswizardcreated = iswizardcreated;
            this.changedFields = changedFields.add("iswizardcreated");
            return this;
        }

        public Builder targetentity(Integer targetentity) {
            this.targetentity = targetentity;
            this.changedFields = changedFields.add("targetentity");
            return this;
        }

        public Builder importmapidunique(String importmapidunique) {
            this.importmapidunique = importmapidunique;
            this.changedFields = changedFields.add("importmapidunique");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder isvalidforimport(Boolean isvalidforimport) {
            this.isvalidforimport = isvalidforimport;
            this.changedFields = changedFields.add("isvalidforimport");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder mapcustomizations(String mapcustomizations) {
            this.mapcustomizations = mapcustomizations;
            this.changedFields = changedFields.add("mapcustomizations");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder sourceuseridentifierforsourcecrmuserlink(String sourceuseridentifierforsourcecrmuserlink) {
            this.sourceuseridentifierforsourcecrmuserlink = sourceuseridentifierforsourcecrmuserlink;
            this.changedFields = changedFields.add("sourceuseridentifierforsourcecrmuserlink");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder importmaptype(Integer importmaptype) {
            this.importmaptype = importmaptype;
            this.changedFields = changedFields.add("importmaptype");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Importmap build() {
            Importmap _x = new Importmap();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.importmap";
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.source = source;
            _x.entitiesperfile = entitiesperfile;
            _x.sourcetype = sourcetype;
            _x.statecode = statecode;
            _x.targetuseridentifierforsourcecrmuserlink = targetuseridentifierforsourcecrmuserlink;
            _x.sourceuseridentifierforsourcedatasourceuserlink = sourceuseridentifierforsourcedatasourceuserlink;
            _x.importmapid = importmapid;
            _x.iswizardcreated = iswizardcreated;
            _x.targetentity = targetentity;
            _x.importmapidunique = importmapidunique;
            _x._ownerid_value = _ownerid_value;
            _x.isvalidforimport = isvalidforimport;
            _x.introducedversion = introducedversion;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.mapcustomizations = mapcustomizations;
            _x._createdby_value = _createdby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.description = description;
            _x.statuscode = statuscode;
            _x.ismanaged = ismanaged;
            _x.name = name;
            _x.overwritetime = overwritetime;
            _x.sourceuseridentifierforsourcecrmuserlink = sourceuseridentifierforsourcecrmuserlink;
            _x.solutionid = solutionid;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.importmaptype = importmaptype;
            _x._owninguser_value = _owninguser_value;
            _x.modifiedon = modifiedon;
            _x.componentstate = componentstate;
            _x._owningteam_value = _owningteam_value;
            _x.createdon = createdon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && importmapid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(importmapid.toString()));
        }
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Importmap with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    public Importmap withSource(String source) {
        Checks.checkIsAscii(source);
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.source = source;
        return _x;
    }

    @Property(name="entitiesperfile")
    @JsonIgnore
    public Optional<Integer> getEntitiesperfile() {
        return Optional.ofNullable(entitiesperfile);
    }

    public Importmap withEntitiesperfile(Integer entitiesperfile) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("entitiesperfile");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.entitiesperfile = entitiesperfile;
        return _x;
    }

    @Property(name="sourcetype")
    @JsonIgnore
    public Optional<Integer> getSourcetype() {
        return Optional.ofNullable(sourcetype);
    }

    public Importmap withSourcetype(Integer sourcetype) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("sourcetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.sourcetype = sourcetype;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Importmap withStatecode(Integer statecode) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="targetuseridentifierforsourcecrmuserlink")
    @JsonIgnore
    public Optional<String> getTargetuseridentifierforsourcecrmuserlink() {
        return Optional.ofNullable(targetuseridentifierforsourcecrmuserlink);
    }

    public Importmap withTargetuseridentifierforsourcecrmuserlink(String targetuseridentifierforsourcecrmuserlink) {
        Checks.checkIsAscii(targetuseridentifierforsourcecrmuserlink);
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("targetuseridentifierforsourcecrmuserlink");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.targetuseridentifierforsourcecrmuserlink = targetuseridentifierforsourcecrmuserlink;
        return _x;
    }

    @Property(name="sourceuseridentifierforsourcedatasourceuserlink")
    @JsonIgnore
    public Optional<String> getSourceuseridentifierforsourcedatasourceuserlink() {
        return Optional.ofNullable(sourceuseridentifierforsourcedatasourceuserlink);
    }

    public Importmap withSourceuseridentifierforsourcedatasourceuserlink(String sourceuseridentifierforsourcedatasourceuserlink) {
        Checks.checkIsAscii(sourceuseridentifierforsourcedatasourceuserlink);
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("sourceuseridentifierforsourcedatasourceuserlink");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.sourceuseridentifierforsourcedatasourceuserlink = sourceuseridentifierforsourcedatasourceuserlink;
        return _x;
    }

    @Property(name="importmapid")
    @JsonIgnore
    public Optional<String> getImportmapid() {
        return Optional.ofNullable(importmapid);
    }

    public Importmap withImportmapid(String importmapid) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("importmapid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.importmapid = importmapid;
        return _x;
    }

    @Property(name="iswizardcreated")
    @JsonIgnore
    public Optional<Boolean> getIswizardcreated() {
        return Optional.ofNullable(iswizardcreated);
    }

    public Importmap withIswizardcreated(Boolean iswizardcreated) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("iswizardcreated");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.iswizardcreated = iswizardcreated;
        return _x;
    }

    @Property(name="targetentity")
    @JsonIgnore
    public Optional<Integer> getTargetentity() {
        return Optional.ofNullable(targetentity);
    }

    public Importmap withTargetentity(Integer targetentity) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("targetentity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.targetentity = targetentity;
        return _x;
    }

    @Property(name="importmapidunique")
    @JsonIgnore
    public Optional<String> getImportmapidunique() {
        return Optional.ofNullable(importmapidunique);
    }

    public Importmap withImportmapidunique(String importmapidunique) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("importmapidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.importmapidunique = importmapidunique;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Importmap with_ownerid_value(String _ownerid_value) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="isvalidforimport")
    @JsonIgnore
    public Optional<Boolean> getIsvalidforimport() {
        return Optional.ofNullable(isvalidforimport);
    }

    public Importmap withIsvalidforimport(Boolean isvalidforimport) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("isvalidforimport");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.isvalidforimport = isvalidforimport;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Importmap withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Importmap with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="mapcustomizations")
    @JsonIgnore
    public Optional<String> getMapcustomizations() {
        return Optional.ofNullable(mapcustomizations);
    }

    public Importmap withMapcustomizations(String mapcustomizations) {
        Checks.checkIsAscii(mapcustomizations);
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("mapcustomizations");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.mapcustomizations = mapcustomizations;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Importmap with_createdby_value(String _createdby_value) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Importmap with_modifiedby_value(String _modifiedby_value) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Importmap withDescription(String description) {
        Checks.checkIsAscii(description);
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.description = description;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Importmap withStatuscode(Integer statuscode) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Importmap withIsmanaged(Boolean ismanaged) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Importmap withName(String name) {
        Checks.checkIsAscii(name);
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.name = name;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Importmap withOverwritetime(OffsetDateTime overwritetime) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="sourceuseridentifierforsourcecrmuserlink")
    @JsonIgnore
    public Optional<String> getSourceuseridentifierforsourcecrmuserlink() {
        return Optional.ofNullable(sourceuseridentifierforsourcecrmuserlink);
    }

    public Importmap withSourceuseridentifierforsourcecrmuserlink(String sourceuseridentifierforsourcecrmuserlink) {
        Checks.checkIsAscii(sourceuseridentifierforsourcecrmuserlink);
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("sourceuseridentifierforsourcecrmuserlink");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.sourceuseridentifierforsourcecrmuserlink = sourceuseridentifierforsourcecrmuserlink;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Importmap withSolutionid(String solutionid) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Importmap with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="importmaptype")
    @JsonIgnore
    public Optional<Integer> getImportmaptype() {
        return Optional.ofNullable(importmaptype);
    }

    public Importmap withImportmaptype(Integer importmaptype) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("importmaptype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.importmaptype = importmaptype;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Importmap with_owninguser_value(String _owninguser_value) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Importmap withModifiedon(OffsetDateTime modifiedon) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Importmap withComponentstate(Integer componentstate) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Importmap with_owningteam_value(String _owningteam_value) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Importmap withCreatedon(OffsetDateTime createdon) {
        Importmap _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importmap");
        _x.createdon = createdon;
        return _x;
    }

    public Importmap withUnmappedField(String name, String value) {
        Importmap _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="ImportMap_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getImportMap_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ImportMap_SyncErrors"), RequestHelper.getValue(unmappedFields, "ImportMap_SyncErrors"));
    }

    @NavigationProperty(name="ColumnMapping_ImportMap")
    @JsonIgnore
    public ColumnmappingCollectionRequest getColumnMapping_ImportMap() {
        return new ColumnmappingCollectionRequest(
                        contextPath.addSegment("ColumnMapping_ImportMap"), RequestHelper.getValue(unmappedFields, "ColumnMapping_ImportMap"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="ImportMap_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getImportMap_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ImportMap_AsyncOperations"), RequestHelper.getValue(unmappedFields, "ImportMap_AsyncOperations"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="ImportEntityMapping_ImportMap")
    @JsonIgnore
    public ImportentitymappingCollectionRequest getImportEntityMapping_ImportMap() {
        return new ImportentitymappingCollectionRequest(
                        contextPath.addSegment("ImportEntityMapping_ImportMap"), RequestHelper.getValue(unmappedFields, "ImportEntityMapping_ImportMap"));
    }

    @NavigationProperty(name="ImportMap_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getImportMap_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ImportMap_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "ImportMap_BulkDeleteFailures"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="OwnerMapping_ImportMap")
    @JsonIgnore
    public OwnermappingCollectionRequest getOwnerMapping_ImportMap() {
        return new OwnermappingCollectionRequest(
                        contextPath.addSegment("OwnerMapping_ImportMap"), RequestHelper.getValue(unmappedFields, "OwnerMapping_ImportMap"));
    }

    @NavigationProperty(name="ImportMap_ImportFile")
    @JsonIgnore
    public ImportfileCollectionRequest getImportMap_ImportFile() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("ImportMap_ImportFile"), RequestHelper.getValue(unmappedFields, "ImportMap_ImportFile"));
    }

    @NavigationProperty(name="TransformationMapping_ImportMap")
    @JsonIgnore
    public TransformationmappingCollectionRequest getTransformationMapping_ImportMap() {
        return new TransformationmappingCollectionRequest(
                        contextPath.addSegment("TransformationMapping_ImportMap"), RequestHelper.getValue(unmappedFields, "TransformationMapping_ImportMap"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importmap patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Importmap _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importmap put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Importmap _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Importmap _copy() {
        Importmap _x = new Importmap();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.source = source;
        _x.entitiesperfile = entitiesperfile;
        _x.sourcetype = sourcetype;
        _x.statecode = statecode;
        _x.targetuseridentifierforsourcecrmuserlink = targetuseridentifierforsourcecrmuserlink;
        _x.sourceuseridentifierforsourcedatasourceuserlink = sourceuseridentifierforsourcedatasourceuserlink;
        _x.importmapid = importmapid;
        _x.iswizardcreated = iswizardcreated;
        _x.targetentity = targetentity;
        _x.importmapidunique = importmapidunique;
        _x._ownerid_value = _ownerid_value;
        _x.isvalidforimport = isvalidforimport;
        _x.introducedversion = introducedversion;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.mapcustomizations = mapcustomizations;
        _x._createdby_value = _createdby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.description = description;
        _x.statuscode = statuscode;
        _x.ismanaged = ismanaged;
        _x.name = name;
        _x.overwritetime = overwritetime;
        _x.sourceuseridentifierforsourcecrmuserlink = sourceuseridentifierforsourcecrmuserlink;
        _x.solutionid = solutionid;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.importmaptype = importmaptype;
        _x._owninguser_value = _owninguser_value;
        _x.modifiedon = modifiedon;
        _x.componentstate = componentstate;
        _x._owningteam_value = _owningteam_value;
        _x.createdon = createdon;
        return _x;
    }

    @Action(name = "ExportMappingsImportMap")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExportMappingsImportMapResponse> exportMappingsImportMap(Boolean exportIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExportIds", "Edm.Boolean", exportIds)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExportMappingsImportMapResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExportMappingsImportMap"), ExportMappingsImportMapResponse.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Importmap[");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("entitiesperfile=");
        b.append(this.entitiesperfile);
        b.append(", ");
        b.append("sourcetype=");
        b.append(this.sourcetype);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("targetuseridentifierforsourcecrmuserlink=");
        b.append(this.targetuseridentifierforsourcecrmuserlink);
        b.append(", ");
        b.append("sourceuseridentifierforsourcedatasourceuserlink=");
        b.append(this.sourceuseridentifierforsourcedatasourceuserlink);
        b.append(", ");
        b.append("importmapid=");
        b.append(this.importmapid);
        b.append(", ");
        b.append("iswizardcreated=");
        b.append(this.iswizardcreated);
        b.append(", ");
        b.append("targetentity=");
        b.append(this.targetentity);
        b.append(", ");
        b.append("importmapidunique=");
        b.append(this.importmapidunique);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("isvalidforimport=");
        b.append(this.isvalidforimport);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("mapcustomizations=");
        b.append(this.mapcustomizations);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("sourceuseridentifierforsourcecrmuserlink=");
        b.append(this.sourceuseridentifierforsourcecrmuserlink);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("importmaptype=");
        b.append(this.importmaptype);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
