package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_transactioncurrencyid_value", 
    "_modifiedonbehalfby_value", 
    "period5", 
    "period6_base", 
    "period5_base", 
    "createdon", 
    "userfiscalcalendarid", 
    "_businessunitid_value", 
    "period13_base", 
    "_salespersonid_value", 
    "period11", 
    "period9_base", 
    "period12", 
    "period13", 
    "period10", 
    "period2_base", 
    "modifiedon", 
    "utcconversiontimezonecode", 
    "period1", 
    "period8_base", 
    "period3", 
    "period2", 
    "exchangerate", 
    "timezoneruleversionnumber", 
    "period11_base", 
    "period8", 
    "period9", 
    "period7_base", 
    "fiscalperiodtype", 
    "_createdby_value", 
    "period1_base", 
    "_createdonbehalfby_value", 
    "effectiveon", 
    "period10_base", 
    "period7", 
    "period6", 
    "_modifiedby_value", 
    "period4", 
    "period3_base", 
    "period12_base", 
    "period4_base"})
@JsonInclude(Include.NON_NULL)
public class Fixedmonthlyfiscalcalendar extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar";
    }

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("period5")
    protected BigDecimal period5;

    @JsonProperty("period6_base")
    protected BigDecimal period6_base;

    @JsonProperty("period5_base")
    protected BigDecimal period5_base;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("userfiscalcalendarid")
    protected String userfiscalcalendarid;

    @JsonProperty("_businessunitid_value")
    protected String _businessunitid_value;

    @JsonProperty("period13_base")
    protected BigDecimal period13_base;

    @JsonProperty("_salespersonid_value")
    protected String _salespersonid_value;

    @JsonProperty("period11")
    protected BigDecimal period11;

    @JsonProperty("period9_base")
    protected BigDecimal period9_base;

    @JsonProperty("period12")
    protected BigDecimal period12;

    @JsonProperty("period13")
    protected BigDecimal period13;

    @JsonProperty("period10")
    protected BigDecimal period10;

    @JsonProperty("period2_base")
    protected BigDecimal period2_base;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("period1")
    protected BigDecimal period1;

    @JsonProperty("period8_base")
    protected BigDecimal period8_base;

    @JsonProperty("period3")
    protected BigDecimal period3;

    @JsonProperty("period2")
    protected BigDecimal period2;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("period11_base")
    protected BigDecimal period11_base;

    @JsonProperty("period8")
    protected BigDecimal period8;

    @JsonProperty("period9")
    protected BigDecimal period9;

    @JsonProperty("period7_base")
    protected BigDecimal period7_base;

    @JsonProperty("fiscalperiodtype")
    protected Integer fiscalperiodtype;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("period1_base")
    protected BigDecimal period1_base;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("effectiveon")
    protected OffsetDateTime effectiveon;

    @JsonProperty("period10_base")
    protected BigDecimal period10_base;

    @JsonProperty("period7")
    protected BigDecimal period7;

    @JsonProperty("period6")
    protected BigDecimal period6;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("period4")
    protected BigDecimal period4;

    @JsonProperty("period3_base")
    protected BigDecimal period3_base;

    @JsonProperty("period12_base")
    protected BigDecimal period12_base;

    @JsonProperty("period4_base")
    protected BigDecimal period4_base;

    protected Fixedmonthlyfiscalcalendar() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFixedmonthlyfiscalcalendar() {
        return new Builder();
    }

    public static final class Builder {
        private String _transactioncurrencyid_value;
        private String _modifiedonbehalfby_value;
        private BigDecimal period5;
        private BigDecimal period6_base;
        private BigDecimal period5_base;
        private OffsetDateTime createdon;
        private String userfiscalcalendarid;
        private String _businessunitid_value;
        private BigDecimal period13_base;
        private String _salespersonid_value;
        private BigDecimal period11;
        private BigDecimal period9_base;
        private BigDecimal period12;
        private BigDecimal period13;
        private BigDecimal period10;
        private BigDecimal period2_base;
        private OffsetDateTime modifiedon;
        private Integer utcconversiontimezonecode;
        private BigDecimal period1;
        private BigDecimal period8_base;
        private BigDecimal period3;
        private BigDecimal period2;
        private BigDecimal exchangerate;
        private Integer timezoneruleversionnumber;
        private BigDecimal period11_base;
        private BigDecimal period8;
        private BigDecimal period9;
        private BigDecimal period7_base;
        private Integer fiscalperiodtype;
        private String _createdby_value;
        private BigDecimal period1_base;
        private String _createdonbehalfby_value;
        private OffsetDateTime effectiveon;
        private BigDecimal period10_base;
        private BigDecimal period7;
        private BigDecimal period6;
        private String _modifiedby_value;
        private BigDecimal period4;
        private BigDecimal period3_base;
        private BigDecimal period12_base;
        private BigDecimal period4_base;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder period5(BigDecimal period5) {
            this.period5 = period5;
            this.changedFields = changedFields.add("period5");
            return this;
        }

        public Builder period6_base(BigDecimal period6_base) {
            this.period6_base = period6_base;
            this.changedFields = changedFields.add("period6_base");
            return this;
        }

        public Builder period5_base(BigDecimal period5_base) {
            this.period5_base = period5_base;
            this.changedFields = changedFields.add("period5_base");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder userfiscalcalendarid(String userfiscalcalendarid) {
            this.userfiscalcalendarid = userfiscalcalendarid;
            this.changedFields = changedFields.add("userfiscalcalendarid");
            return this;
        }

        public Builder _businessunitid_value(String _businessunitid_value) {
            this._businessunitid_value = _businessunitid_value;
            this.changedFields = changedFields.add("_businessunitid_value");
            return this;
        }

        public Builder period13_base(BigDecimal period13_base) {
            this.period13_base = period13_base;
            this.changedFields = changedFields.add("period13_base");
            return this;
        }

        public Builder _salespersonid_value(String _salespersonid_value) {
            this._salespersonid_value = _salespersonid_value;
            this.changedFields = changedFields.add("_salespersonid_value");
            return this;
        }

        public Builder period11(BigDecimal period11) {
            this.period11 = period11;
            this.changedFields = changedFields.add("period11");
            return this;
        }

        public Builder period9_base(BigDecimal period9_base) {
            this.period9_base = period9_base;
            this.changedFields = changedFields.add("period9_base");
            return this;
        }

        public Builder period12(BigDecimal period12) {
            this.period12 = period12;
            this.changedFields = changedFields.add("period12");
            return this;
        }

        public Builder period13(BigDecimal period13) {
            this.period13 = period13;
            this.changedFields = changedFields.add("period13");
            return this;
        }

        public Builder period10(BigDecimal period10) {
            this.period10 = period10;
            this.changedFields = changedFields.add("period10");
            return this;
        }

        public Builder period2_base(BigDecimal period2_base) {
            this.period2_base = period2_base;
            this.changedFields = changedFields.add("period2_base");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder period1(BigDecimal period1) {
            this.period1 = period1;
            this.changedFields = changedFields.add("period1");
            return this;
        }

        public Builder period8_base(BigDecimal period8_base) {
            this.period8_base = period8_base;
            this.changedFields = changedFields.add("period8_base");
            return this;
        }

        public Builder period3(BigDecimal period3) {
            this.period3 = period3;
            this.changedFields = changedFields.add("period3");
            return this;
        }

        public Builder period2(BigDecimal period2) {
            this.period2 = period2;
            this.changedFields = changedFields.add("period2");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder period11_base(BigDecimal period11_base) {
            this.period11_base = period11_base;
            this.changedFields = changedFields.add("period11_base");
            return this;
        }

        public Builder period8(BigDecimal period8) {
            this.period8 = period8;
            this.changedFields = changedFields.add("period8");
            return this;
        }

        public Builder period9(BigDecimal period9) {
            this.period9 = period9;
            this.changedFields = changedFields.add("period9");
            return this;
        }

        public Builder period7_base(BigDecimal period7_base) {
            this.period7_base = period7_base;
            this.changedFields = changedFields.add("period7_base");
            return this;
        }

        public Builder fiscalperiodtype(Integer fiscalperiodtype) {
            this.fiscalperiodtype = fiscalperiodtype;
            this.changedFields = changedFields.add("fiscalperiodtype");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder period1_base(BigDecimal period1_base) {
            this.period1_base = period1_base;
            this.changedFields = changedFields.add("period1_base");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder effectiveon(OffsetDateTime effectiveon) {
            this.effectiveon = effectiveon;
            this.changedFields = changedFields.add("effectiveon");
            return this;
        }

        public Builder period10_base(BigDecimal period10_base) {
            this.period10_base = period10_base;
            this.changedFields = changedFields.add("period10_base");
            return this;
        }

        public Builder period7(BigDecimal period7) {
            this.period7 = period7;
            this.changedFields = changedFields.add("period7");
            return this;
        }

        public Builder period6(BigDecimal period6) {
            this.period6 = period6;
            this.changedFields = changedFields.add("period6");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder period4(BigDecimal period4) {
            this.period4 = period4;
            this.changedFields = changedFields.add("period4");
            return this;
        }

        public Builder period3_base(BigDecimal period3_base) {
            this.period3_base = period3_base;
            this.changedFields = changedFields.add("period3_base");
            return this;
        }

        public Builder period12_base(BigDecimal period12_base) {
            this.period12_base = period12_base;
            this.changedFields = changedFields.add("period12_base");
            return this;
        }

        public Builder period4_base(BigDecimal period4_base) {
            this.period4_base = period4_base;
            this.changedFields = changedFields.add("period4_base");
            return this;
        }

        public Fixedmonthlyfiscalcalendar build() {
            Fixedmonthlyfiscalcalendar _x = new Fixedmonthlyfiscalcalendar();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar";
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.period5 = period5;
            _x.period6_base = period6_base;
            _x.period5_base = period5_base;
            _x.createdon = createdon;
            _x.userfiscalcalendarid = userfiscalcalendarid;
            _x._businessunitid_value = _businessunitid_value;
            _x.period13_base = period13_base;
            _x._salespersonid_value = _salespersonid_value;
            _x.period11 = period11;
            _x.period9_base = period9_base;
            _x.period12 = period12;
            _x.period13 = period13;
            _x.period10 = period10;
            _x.period2_base = period2_base;
            _x.modifiedon = modifiedon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.period1 = period1;
            _x.period8_base = period8_base;
            _x.period3 = period3;
            _x.period2 = period2;
            _x.exchangerate = exchangerate;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.period11_base = period11_base;
            _x.period8 = period8;
            _x.period9 = period9;
            _x.period7_base = period7_base;
            _x.fiscalperiodtype = fiscalperiodtype;
            _x._createdby_value = _createdby_value;
            _x.period1_base = period1_base;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.effectiveon = effectiveon;
            _x.period10_base = period10_base;
            _x.period7 = period7;
            _x.period6 = period6;
            _x._modifiedby_value = _modifiedby_value;
            _x.period4 = period4;
            _x.period3_base = period3_base;
            _x.period12_base = period12_base;
            _x.period4_base = period4_base;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && userfiscalcalendarid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(userfiscalcalendarid.toString()));
        }
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Fixedmonthlyfiscalcalendar with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Fixedmonthlyfiscalcalendar with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="period5")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod5() {
        return Optional.ofNullable(period5);
    }

    public Fixedmonthlyfiscalcalendar withPeriod5(BigDecimal period5) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period5");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period5 = period5;
        return _x;
    }

    @Property(name="period6_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod6_base() {
        return Optional.ofNullable(period6_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod6_base(BigDecimal period6_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period6_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period6_base = period6_base;
        return _x;
    }

    @Property(name="period5_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod5_base() {
        return Optional.ofNullable(period5_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod5_base(BigDecimal period5_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period5_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period5_base = period5_base;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Fixedmonthlyfiscalcalendar withCreatedon(OffsetDateTime createdon) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="userfiscalcalendarid")
    @JsonIgnore
    public Optional<String> getUserfiscalcalendarid() {
        return Optional.ofNullable(userfiscalcalendarid);
    }

    public Fixedmonthlyfiscalcalendar withUserfiscalcalendarid(String userfiscalcalendarid) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("userfiscalcalendarid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.userfiscalcalendarid = userfiscalcalendarid;
        return _x;
    }

    @Property(name="_businessunitid_value")
    @JsonIgnore
    public Optional<String> get_businessunitid_value() {
        return Optional.ofNullable(_businessunitid_value);
    }

    public Fixedmonthlyfiscalcalendar with_businessunitid_value(String _businessunitid_value) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_businessunitid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x._businessunitid_value = _businessunitid_value;
        return _x;
    }

    @Property(name="period13_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod13_base() {
        return Optional.ofNullable(period13_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod13_base(BigDecimal period13_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period13_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period13_base = period13_base;
        return _x;
    }

    @Property(name="_salespersonid_value")
    @JsonIgnore
    public Optional<String> get_salespersonid_value() {
        return Optional.ofNullable(_salespersonid_value);
    }

    public Fixedmonthlyfiscalcalendar with_salespersonid_value(String _salespersonid_value) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_salespersonid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x._salespersonid_value = _salespersonid_value;
        return _x;
    }

    @Property(name="period11")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod11() {
        return Optional.ofNullable(period11);
    }

    public Fixedmonthlyfiscalcalendar withPeriod11(BigDecimal period11) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period11");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period11 = period11;
        return _x;
    }

    @Property(name="period9_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod9_base() {
        return Optional.ofNullable(period9_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod9_base(BigDecimal period9_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period9_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period9_base = period9_base;
        return _x;
    }

    @Property(name="period12")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod12() {
        return Optional.ofNullable(period12);
    }

    public Fixedmonthlyfiscalcalendar withPeriod12(BigDecimal period12) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period12");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period12 = period12;
        return _x;
    }

    @Property(name="period13")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod13() {
        return Optional.ofNullable(period13);
    }

    public Fixedmonthlyfiscalcalendar withPeriod13(BigDecimal period13) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period13");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period13 = period13;
        return _x;
    }

    @Property(name="period10")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod10() {
        return Optional.ofNullable(period10);
    }

    public Fixedmonthlyfiscalcalendar withPeriod10(BigDecimal period10) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period10");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period10 = period10;
        return _x;
    }

    @Property(name="period2_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod2_base() {
        return Optional.ofNullable(period2_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod2_base(BigDecimal period2_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period2_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period2_base = period2_base;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Fixedmonthlyfiscalcalendar withModifiedon(OffsetDateTime modifiedon) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Fixedmonthlyfiscalcalendar withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="period1")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod1() {
        return Optional.ofNullable(period1);
    }

    public Fixedmonthlyfiscalcalendar withPeriod1(BigDecimal period1) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period1");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period1 = period1;
        return _x;
    }

    @Property(name="period8_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod8_base() {
        return Optional.ofNullable(period8_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod8_base(BigDecimal period8_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period8_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period8_base = period8_base;
        return _x;
    }

    @Property(name="period3")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod3() {
        return Optional.ofNullable(period3);
    }

    public Fixedmonthlyfiscalcalendar withPeriod3(BigDecimal period3) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period3");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period3 = period3;
        return _x;
    }

    @Property(name="period2")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod2() {
        return Optional.ofNullable(period2);
    }

    public Fixedmonthlyfiscalcalendar withPeriod2(BigDecimal period2) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period2");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period2 = period2;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Fixedmonthlyfiscalcalendar withExchangerate(BigDecimal exchangerate) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Fixedmonthlyfiscalcalendar withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="period11_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod11_base() {
        return Optional.ofNullable(period11_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod11_base(BigDecimal period11_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period11_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period11_base = period11_base;
        return _x;
    }

    @Property(name="period8")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod8() {
        return Optional.ofNullable(period8);
    }

    public Fixedmonthlyfiscalcalendar withPeriod8(BigDecimal period8) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period8");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period8 = period8;
        return _x;
    }

    @Property(name="period9")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod9() {
        return Optional.ofNullable(period9);
    }

    public Fixedmonthlyfiscalcalendar withPeriod9(BigDecimal period9) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period9");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period9 = period9;
        return _x;
    }

    @Property(name="period7_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod7_base() {
        return Optional.ofNullable(period7_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod7_base(BigDecimal period7_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period7_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period7_base = period7_base;
        return _x;
    }

    @Property(name="fiscalperiodtype")
    @JsonIgnore
    public Optional<Integer> getFiscalperiodtype() {
        return Optional.ofNullable(fiscalperiodtype);
    }

    public Fixedmonthlyfiscalcalendar withFiscalperiodtype(Integer fiscalperiodtype) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("fiscalperiodtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.fiscalperiodtype = fiscalperiodtype;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Fixedmonthlyfiscalcalendar with_createdby_value(String _createdby_value) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="period1_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod1_base() {
        return Optional.ofNullable(period1_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod1_base(BigDecimal period1_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period1_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period1_base = period1_base;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Fixedmonthlyfiscalcalendar with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="effectiveon")
    @JsonIgnore
    public Optional<OffsetDateTime> getEffectiveon() {
        return Optional.ofNullable(effectiveon);
    }

    public Fixedmonthlyfiscalcalendar withEffectiveon(OffsetDateTime effectiveon) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("effectiveon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.effectiveon = effectiveon;
        return _x;
    }

    @Property(name="period10_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod10_base() {
        return Optional.ofNullable(period10_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod10_base(BigDecimal period10_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period10_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period10_base = period10_base;
        return _x;
    }

    @Property(name="period7")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod7() {
        return Optional.ofNullable(period7);
    }

    public Fixedmonthlyfiscalcalendar withPeriod7(BigDecimal period7) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period7");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period7 = period7;
        return _x;
    }

    @Property(name="period6")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod6() {
        return Optional.ofNullable(period6);
    }

    public Fixedmonthlyfiscalcalendar withPeriod6(BigDecimal period6) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period6");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period6 = period6;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Fixedmonthlyfiscalcalendar with_modifiedby_value(String _modifiedby_value) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="period4")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod4() {
        return Optional.ofNullable(period4);
    }

    public Fixedmonthlyfiscalcalendar withPeriod4(BigDecimal period4) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period4");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period4 = period4;
        return _x;
    }

    @Property(name="period3_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod3_base() {
        return Optional.ofNullable(period3_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod3_base(BigDecimal period3_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period3_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period3_base = period3_base;
        return _x;
    }

    @Property(name="period12_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod12_base() {
        return Optional.ofNullable(period12_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod12_base(BigDecimal period12_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period12_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period12_base = period12_base;
        return _x;
    }

    @Property(name="period4_base")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod4_base() {
        return Optional.ofNullable(period4_base);
    }

    public Fixedmonthlyfiscalcalendar withPeriod4_base(BigDecimal period4_base) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("period4_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fixedmonthlyfiscalcalendar");
        _x.period4_base = period4_base;
        return _x;
    }

    public Fixedmonthlyfiscalcalendar withUnmappedField(String name, String value) {
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="FixedMonthlyFiscalCalendar_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getFixedMonthlyFiscalCalendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("FixedMonthlyFiscalCalendar_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "FixedMonthlyFiscalCalendar_BulkDeleteFailures"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="FixedMonthlyFiscalCalendar_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getFixedMonthlyFiscalCalendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("FixedMonthlyFiscalCalendar_AsyncOperations"), RequestHelper.getValue(unmappedFields, "FixedMonthlyFiscalCalendar_AsyncOperations"));
    }

    @NavigationProperty(name="salespersonid")
    @JsonIgnore
    public SystemuserRequest getSalespersonid() {
        return new SystemuserRequest(contextPath.addSegment("salespersonid"), RequestHelper.getValue(unmappedFields, "salespersonid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Fixedmonthlyfiscalcalendar patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Fixedmonthlyfiscalcalendar put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Fixedmonthlyfiscalcalendar _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Fixedmonthlyfiscalcalendar _copy() {
        Fixedmonthlyfiscalcalendar _x = new Fixedmonthlyfiscalcalendar();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.period5 = period5;
        _x.period6_base = period6_base;
        _x.period5_base = period5_base;
        _x.createdon = createdon;
        _x.userfiscalcalendarid = userfiscalcalendarid;
        _x._businessunitid_value = _businessunitid_value;
        _x.period13_base = period13_base;
        _x._salespersonid_value = _salespersonid_value;
        _x.period11 = period11;
        _x.period9_base = period9_base;
        _x.period12 = period12;
        _x.period13 = period13;
        _x.period10 = period10;
        _x.period2_base = period2_base;
        _x.modifiedon = modifiedon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.period1 = period1;
        _x.period8_base = period8_base;
        _x.period3 = period3;
        _x.period2 = period2;
        _x.exchangerate = exchangerate;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.period11_base = period11_base;
        _x.period8 = period8;
        _x.period9 = period9;
        _x.period7_base = period7_base;
        _x.fiscalperiodtype = fiscalperiodtype;
        _x._createdby_value = _createdby_value;
        _x.period1_base = period1_base;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.effectiveon = effectiveon;
        _x.period10_base = period10_base;
        _x.period7 = period7;
        _x.period6 = period6;
        _x._modifiedby_value = _modifiedby_value;
        _x.period4 = period4;
        _x.period3_base = period3_base;
        _x.period12_base = period12_base;
        _x.period4_base = period4_base;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Fixedmonthlyfiscalcalendar[");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("period5=");
        b.append(this.period5);
        b.append(", ");
        b.append("period6_base=");
        b.append(this.period6_base);
        b.append(", ");
        b.append("period5_base=");
        b.append(this.period5_base);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("userfiscalcalendarid=");
        b.append(this.userfiscalcalendarid);
        b.append(", ");
        b.append("_businessunitid_value=");
        b.append(this._businessunitid_value);
        b.append(", ");
        b.append("period13_base=");
        b.append(this.period13_base);
        b.append(", ");
        b.append("_salespersonid_value=");
        b.append(this._salespersonid_value);
        b.append(", ");
        b.append("period11=");
        b.append(this.period11);
        b.append(", ");
        b.append("period9_base=");
        b.append(this.period9_base);
        b.append(", ");
        b.append("period12=");
        b.append(this.period12);
        b.append(", ");
        b.append("period13=");
        b.append(this.period13);
        b.append(", ");
        b.append("period10=");
        b.append(this.period10);
        b.append(", ");
        b.append("period2_base=");
        b.append(this.period2_base);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("period1=");
        b.append(this.period1);
        b.append(", ");
        b.append("period8_base=");
        b.append(this.period8_base);
        b.append(", ");
        b.append("period3=");
        b.append(this.period3);
        b.append(", ");
        b.append("period2=");
        b.append(this.period2);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("period11_base=");
        b.append(this.period11_base);
        b.append(", ");
        b.append("period8=");
        b.append(this.period8);
        b.append(", ");
        b.append("period9=");
        b.append(this.period9);
        b.append(", ");
        b.append("period7_base=");
        b.append(this.period7_base);
        b.append(", ");
        b.append("fiscalperiodtype=");
        b.append(this.fiscalperiodtype);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("period1_base=");
        b.append(this.period1_base);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("effectiveon=");
        b.append(this.effectiveon);
        b.append(", ");
        b.append("period10_base=");
        b.append(this.period10_base);
        b.append(", ");
        b.append("period7=");
        b.append(this.period7);
        b.append(", ");
        b.append("period6=");
        b.append(this.period6);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("period4=");
        b.append(this.period4);
        b.append(", ");
        b.append("period3_base=");
        b.append(this.period3_base);
        b.append(", ");
        b.append("period12_base=");
        b.append(this.period12_base);
        b.append(", ");
        b.append("period4_base=");
        b.append(this.period4_base);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
