package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.enums.EntityKeyIndexStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "DisplayName", 
    "LogicalName", 
    "SchemaName", 
    "EntityLogicalName", 
    "KeyAttributes", 
    "IsCustomizable", 
    "IsManaged", 
    "IntroducedVersion", 
    "EntityKeyIndexStatus", 
    "AsyncJob", 
    "IsSynchronous", 
    "IsExportKey"})
@JsonInclude(Include.NON_NULL)
public class EntityKeyMetadata extends MetadataBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityKeyMetadata";
    }

    @JsonProperty("DisplayName")
    protected Label displayName;

    @JsonProperty("LogicalName")
    protected String logicalName;

    @JsonProperty("SchemaName")
    protected String schemaName;

    @JsonProperty("EntityLogicalName")
    protected String entityLogicalName;

    @JsonProperty("KeyAttributes")
    protected List<String> keyAttributes;

    @JsonProperty("KeyAttributes@nextLink")
    protected String keyAttributesNextLink;

    @JsonProperty("IsCustomizable")
    protected BooleanManagedProperty isCustomizable;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("IntroducedVersion")
    protected String introducedVersion;

    @JsonProperty("EntityKeyIndexStatus")
    protected EntityKeyIndexStatus entityKeyIndexStatus;

    @JsonProperty("AsyncJob")
    protected String asyncJob;

    @JsonProperty("IsSynchronous")
    protected Boolean isSynchronous;

    @JsonProperty("IsExportKey")
    protected Boolean isExportKey;

    protected EntityKeyMetadata() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntityKeyMetadata() {
        return new Builder();
    }

    public static final class Builder {
        private String metadataId;
        private Boolean hasChanged;
        private Label displayName;
        private String logicalName;
        private String schemaName;
        private String entityLogicalName;
        private List<String> keyAttributes;
        private String keyAttributesNextLink;
        private BooleanManagedProperty isCustomizable;
        private Boolean isManaged;
        private String introducedVersion;
        private EntityKeyIndexStatus entityKeyIndexStatus;
        private String asyncJob;
        private Boolean isSynchronous;
        private Boolean isExportKey;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = changedFields.add("LogicalName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = changedFields.add("SchemaName");
            return this;
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder keyAttributes(List<String> keyAttributes) {
            this.keyAttributes = keyAttributes;
            this.changedFields = changedFields.add("KeyAttributes");
            return this;
        }

        public Builder keyAttributes(String... keyAttributes) {
            return keyAttributes(Arrays.asList(keyAttributes));
        }

        public Builder keyAttributesNextLink(String keyAttributesNextLink) {
            this.keyAttributesNextLink = keyAttributesNextLink;
            this.changedFields = changedFields.add("KeyAttributes");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder entityKeyIndexStatus(EntityKeyIndexStatus entityKeyIndexStatus) {
            this.entityKeyIndexStatus = entityKeyIndexStatus;
            this.changedFields = changedFields.add("EntityKeyIndexStatus");
            return this;
        }

        public Builder asyncJob(String asyncJob) {
            this.asyncJob = asyncJob;
            this.changedFields = changedFields.add("AsyncJob");
            return this;
        }

        public Builder isSynchronous(Boolean isSynchronous) {
            this.isSynchronous = isSynchronous;
            this.changedFields = changedFields.add("IsSynchronous");
            return this;
        }

        public Builder isExportKey(Boolean isExportKey) {
            this.isExportKey = isExportKey;
            this.changedFields = changedFields.add("IsExportKey");
            return this;
        }

        public EntityKeyMetadata build() {
            EntityKeyMetadata _x = new EntityKeyMetadata();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityKeyMetadata";
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            _x.displayName = displayName;
            _x.logicalName = logicalName;
            _x.schemaName = schemaName;
            _x.entityLogicalName = entityLogicalName;
            _x.keyAttributes = keyAttributes;
            _x.keyAttributesNextLink = keyAttributesNextLink;
            _x.isCustomizable = isCustomizable;
            _x.isManaged = isManaged;
            _x.introducedVersion = introducedVersion;
            _x.entityKeyIndexStatus = entityKeyIndexStatus;
            _x.asyncJob = asyncJob;
            _x.isSynchronous = isSynchronous;
            _x.isExportKey = isExportKey;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && metadataId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(metadataId.toString()));
        }
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EntityKeyMetadata withDisplayName(Label displayName) {
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("DisplayName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(logicalName);
    }

    public EntityKeyMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii(logicalName);
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("LogicalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(schemaName);
    }

    public EntityKeyMetadata withSchemaName(String schemaName) {
        Checks.checkIsAscii(schemaName);
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("SchemaName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(entityLogicalName);
    }

    public EntityKeyMetadata withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii(entityLogicalName);
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("EntityLogicalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="KeyAttributes")
    @JsonIgnore
    public CollectionPage<String> getKeyAttributes() {
        return new CollectionPage<String>(contextPath, String.class, this.keyAttributes, Optional.ofNullable(keyAttributesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public EntityKeyMetadata withKeyAttributes(List<String> keyAttributes) {
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("KeyAttributes");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.keyAttributes = keyAttributes;
        return _x;
    }

    @Property(name="KeyAttributes")
    @JsonIgnore
    public CollectionPage<String> getKeyAttributes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.keyAttributes, Optional.ofNullable(keyAttributesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public EntityKeyMetadata withIsCustomizable(BooleanManagedProperty isCustomizable) {
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsCustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public EntityKeyMetadata withIsManaged(Boolean isManaged) {
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsManaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(introducedVersion);
    }

    public EntityKeyMetadata withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii(introducedVersion);
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("IntroducedVersion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Property(name="EntityKeyIndexStatus")
    @JsonIgnore
    public Optional<EntityKeyIndexStatus> getEntityKeyIndexStatus() {
        return Optional.ofNullable(entityKeyIndexStatus);
    }

    public EntityKeyMetadata withEntityKeyIndexStatus(EntityKeyIndexStatus entityKeyIndexStatus) {
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("EntityKeyIndexStatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.entityKeyIndexStatus = entityKeyIndexStatus;
        return _x;
    }

    @Property(name="AsyncJob")
    @JsonIgnore
    public Optional<String> getAsyncJob() {
        return Optional.ofNullable(asyncJob);
    }

    public EntityKeyMetadata withAsyncJob(String asyncJob) {
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("AsyncJob");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.asyncJob = asyncJob;
        return _x;
    }

    @Property(name="IsSynchronous")
    @JsonIgnore
    public Optional<Boolean> getIsSynchronous() {
        return Optional.ofNullable(isSynchronous);
    }

    public EntityKeyMetadata withIsSynchronous(Boolean isSynchronous) {
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsSynchronous");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.isSynchronous = isSynchronous;
        return _x;
    }

    @Property(name="IsExportKey")
    @JsonIgnore
    public Optional<Boolean> getIsExportKey() {
        return Optional.ofNullable(isExportKey);
    }

    public EntityKeyMetadata withIsExportKey(Boolean isExportKey) {
        EntityKeyMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsExportKey");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.isExportKey = isExportKey;
        return _x;
    }

    public EntityKeyMetadata withUnmappedField(String name, String value) {
        EntityKeyMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EntityKeyMetadata patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EntityKeyMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EntityKeyMetadata put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EntityKeyMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EntityKeyMetadata _copy() {
        EntityKeyMetadata _x = new EntityKeyMetadata();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        _x.displayName = displayName;
        _x.logicalName = logicalName;
        _x.schemaName = schemaName;
        _x.entityLogicalName = entityLogicalName;
        _x.keyAttributes = keyAttributes;
        _x.isCustomizable = isCustomizable;
        _x.isManaged = isManaged;
        _x.introducedVersion = introducedVersion;
        _x.entityKeyIndexStatus = entityKeyIndexStatus;
        _x.asyncJob = asyncJob;
        _x.isSynchronous = isSynchronous;
        _x.isExportKey = isExportKey;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityKeyMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("KeyAttributes=");
        b.append(this.keyAttributes);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("EntityKeyIndexStatus=");
        b.append(this.entityKeyIndexStatus);
        b.append(", ");
        b.append("AsyncJob=");
        b.append(this.asyncJob);
        b.append(", ");
        b.append("IsSynchronous=");
        b.append(this.isSynchronous);
        b.append(", ");
        b.append("IsExportKey=");
        b.append(this.isExportKey);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
