package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "primaryentitytypecode", 
    "controldescriptionjson", 
    "_createdonbehalfby_value", 
    "_modifiedonbehalfby_value", 
    "componentstate", 
    "ismanaged", 
    "eventsxml", 
    "customcontroldefaultconfigid", 
    "solutionid", 
    "_createdby_value", 
    "introducedversion", 
    "_organizationid_value", 
    "createdon", 
    "customcontroldefaultconfigidunique", 
    "overwritetime", 
    "versionnumber", 
    "modifiedon", 
    "controldescriptionxml", 
    "_modifiedby_value"})
@JsonInclude(Include.NON_NULL)
public class Customcontroldefaultconfig extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.customcontroldefaultconfig";
    }

    @JsonProperty("primaryentitytypecode")
    protected String primaryentitytypecode;

    @JsonProperty("controldescriptionjson")
    protected String controldescriptionjson;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("eventsxml")
    protected String eventsxml;

    @JsonProperty("customcontroldefaultconfigid")
    protected String customcontroldefaultconfigid;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("customcontroldefaultconfigidunique")
    protected String customcontroldefaultconfigidunique;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("controldescriptionxml")
    protected String controldescriptionxml;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    protected Customcontroldefaultconfig() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCustomcontroldefaultconfig() {
        return new Builder();
    }

    public static final class Builder {
        private String primaryentitytypecode;
        private String controldescriptionjson;
        private String _createdonbehalfby_value;
        private String _modifiedonbehalfby_value;
        private Integer componentstate;
        private Boolean ismanaged;
        private String eventsxml;
        private String customcontroldefaultconfigid;
        private String solutionid;
        private String _createdby_value;
        private String introducedversion;
        private String _organizationid_value;
        private OffsetDateTime createdon;
        private String customcontroldefaultconfigidunique;
        private OffsetDateTime overwritetime;
        private Long versionnumber;
        private OffsetDateTime modifiedon;
        private String controldescriptionxml;
        private String _modifiedby_value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder primaryentitytypecode(String primaryentitytypecode) {
            this.primaryentitytypecode = primaryentitytypecode;
            this.changedFields = changedFields.add("primaryentitytypecode");
            return this;
        }

        public Builder controldescriptionjson(String controldescriptionjson) {
            this.controldescriptionjson = controldescriptionjson;
            this.changedFields = changedFields.add("controldescriptionjson");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder eventsxml(String eventsxml) {
            this.eventsxml = eventsxml;
            this.changedFields = changedFields.add("eventsxml");
            return this;
        }

        public Builder customcontroldefaultconfigid(String customcontroldefaultconfigid) {
            this.customcontroldefaultconfigid = customcontroldefaultconfigid;
            this.changedFields = changedFields.add("customcontroldefaultconfigid");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder customcontroldefaultconfigidunique(String customcontroldefaultconfigidunique) {
            this.customcontroldefaultconfigidunique = customcontroldefaultconfigidunique;
            this.changedFields = changedFields.add("customcontroldefaultconfigidunique");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder controldescriptionxml(String controldescriptionxml) {
            this.controldescriptionxml = controldescriptionxml;
            this.changedFields = changedFields.add("controldescriptionxml");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Customcontroldefaultconfig build() {
            Customcontroldefaultconfig _x = new Customcontroldefaultconfig();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.customcontroldefaultconfig";
            _x.primaryentitytypecode = primaryentitytypecode;
            _x.controldescriptionjson = controldescriptionjson;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.componentstate = componentstate;
            _x.ismanaged = ismanaged;
            _x.eventsxml = eventsxml;
            _x.customcontroldefaultconfigid = customcontroldefaultconfigid;
            _x.solutionid = solutionid;
            _x._createdby_value = _createdby_value;
            _x.introducedversion = introducedversion;
            _x._organizationid_value = _organizationid_value;
            _x.createdon = createdon;
            _x.customcontroldefaultconfigidunique = customcontroldefaultconfigidunique;
            _x.overwritetime = overwritetime;
            _x.versionnumber = versionnumber;
            _x.modifiedon = modifiedon;
            _x.controldescriptionxml = controldescriptionxml;
            _x._modifiedby_value = _modifiedby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && customcontroldefaultconfigid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(customcontroldefaultconfigid.toString()));
        }
    }

    @Property(name="primaryentitytypecode")
    @JsonIgnore
    public Optional<String> getPrimaryentitytypecode() {
        return Optional.ofNullable(primaryentitytypecode);
    }

    public Customcontroldefaultconfig withPrimaryentitytypecode(String primaryentitytypecode) {
        Checks.checkIsAscii(primaryentitytypecode);
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("primaryentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.primaryentitytypecode = primaryentitytypecode;
        return _x;
    }

    @Property(name="controldescriptionjson")
    @JsonIgnore
    public Optional<String> getControldescriptionjson() {
        return Optional.ofNullable(controldescriptionjson);
    }

    public Customcontroldefaultconfig withControldescriptionjson(String controldescriptionjson) {
        Checks.checkIsAscii(controldescriptionjson);
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("controldescriptionjson");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.controldescriptionjson = controldescriptionjson;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Customcontroldefaultconfig with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Customcontroldefaultconfig with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Customcontroldefaultconfig withComponentstate(Integer componentstate) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Customcontroldefaultconfig withIsmanaged(Boolean ismanaged) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="eventsxml")
    @JsonIgnore
    public Optional<String> getEventsxml() {
        return Optional.ofNullable(eventsxml);
    }

    public Customcontroldefaultconfig withEventsxml(String eventsxml) {
        Checks.checkIsAscii(eventsxml);
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("eventsxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.eventsxml = eventsxml;
        return _x;
    }

    @Property(name="customcontroldefaultconfigid")
    @JsonIgnore
    public Optional<String> getCustomcontroldefaultconfigid() {
        return Optional.ofNullable(customcontroldefaultconfigid);
    }

    public Customcontroldefaultconfig withCustomcontroldefaultconfigid(String customcontroldefaultconfigid) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("customcontroldefaultconfigid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.customcontroldefaultconfigid = customcontroldefaultconfigid;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Customcontroldefaultconfig withSolutionid(String solutionid) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Customcontroldefaultconfig with_createdby_value(String _createdby_value) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Customcontroldefaultconfig withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Customcontroldefaultconfig with_organizationid_value(String _organizationid_value) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Customcontroldefaultconfig withCreatedon(OffsetDateTime createdon) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="customcontroldefaultconfigidunique")
    @JsonIgnore
    public Optional<String> getCustomcontroldefaultconfigidunique() {
        return Optional.ofNullable(customcontroldefaultconfigidunique);
    }

    public Customcontroldefaultconfig withCustomcontroldefaultconfigidunique(String customcontroldefaultconfigidunique) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("customcontroldefaultconfigidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.customcontroldefaultconfigidunique = customcontroldefaultconfigidunique;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Customcontroldefaultconfig withOverwritetime(OffsetDateTime overwritetime) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Customcontroldefaultconfig withVersionnumber(Long versionnumber) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Customcontroldefaultconfig withModifiedon(OffsetDateTime modifiedon) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="controldescriptionxml")
    @JsonIgnore
    public Optional<String> getControldescriptionxml() {
        return Optional.ofNullable(controldescriptionxml);
    }

    public Customcontroldefaultconfig withControldescriptionxml(String controldescriptionxml) {
        Checks.checkIsAscii(controldescriptionxml);
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("controldescriptionxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x.controldescriptionxml = controldescriptionxml;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Customcontroldefaultconfig with_modifiedby_value(String _modifiedby_value) {
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontroldefaultconfig");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    public Customcontroldefaultconfig withUnmappedField(String name, String value) {
        Customcontroldefaultconfig _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Customcontroldefaultconfig patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Customcontroldefaultconfig put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Customcontroldefaultconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Customcontroldefaultconfig _copy() {
        Customcontroldefaultconfig _x = new Customcontroldefaultconfig();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.primaryentitytypecode = primaryentitytypecode;
        _x.controldescriptionjson = controldescriptionjson;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.componentstate = componentstate;
        _x.ismanaged = ismanaged;
        _x.eventsxml = eventsxml;
        _x.customcontroldefaultconfigid = customcontroldefaultconfigid;
        _x.solutionid = solutionid;
        _x._createdby_value = _createdby_value;
        _x.introducedversion = introducedversion;
        _x._organizationid_value = _organizationid_value;
        _x.createdon = createdon;
        _x.customcontroldefaultconfigidunique = customcontroldefaultconfigidunique;
        _x.overwritetime = overwritetime;
        _x.versionnumber = versionnumber;
        _x.modifiedon = modifiedon;
        _x.controldescriptionxml = controldescriptionxml;
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Customcontroldefaultconfig> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Customcontroldefaultconfig>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Customcontroldefaultconfig.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Customcontroldefaultconfig[");
        b.append("primaryentitytypecode=");
        b.append(this.primaryentitytypecode);
        b.append(", ");
        b.append("controldescriptionjson=");
        b.append(this.controldescriptionjson);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("eventsxml=");
        b.append(this.eventsxml);
        b.append(", ");
        b.append("customcontroldefaultconfigid=");
        b.append(this.customcontroldefaultconfigid);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("customcontroldefaultconfigidunique=");
        b.append(this.customcontroldefaultconfigidunique);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("controldescriptionxml=");
        b.append(this.controldescriptionxml);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
