package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentidunique", 
    "versionnumber", 
    "solutionid", 
    "componentstate", 
    "parententitylogicalname", 
    "ismanaged", 
    "canstorefullimage", 
    "attributeimageconfigid", 
    "overwritetime", 
    "attributelogicalname"})
@JsonInclude(Include.NON_NULL)
public class Attributeimageconfig extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.attributeimageconfig";
    }

    @JsonProperty("componentidunique")
    protected String componentidunique;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("parententitylogicalname")
    protected String parententitylogicalname;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("canstorefullimage")
    protected Boolean canstorefullimage;

    @JsonProperty("attributeimageconfigid")
    protected String attributeimageconfigid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("attributelogicalname")
    protected String attributelogicalname;

    protected Attributeimageconfig() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAttributeimageconfig() {
        return new Builder();
    }

    public static final class Builder {
        private String componentidunique;
        private Long versionnumber;
        private String solutionid;
        private Integer componentstate;
        private String parententitylogicalname;
        private Boolean ismanaged;
        private Boolean canstorefullimage;
        private String attributeimageconfigid;
        private OffsetDateTime overwritetime;
        private String attributelogicalname;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder componentidunique(String componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder parententitylogicalname(String parententitylogicalname) {
            this.parententitylogicalname = parententitylogicalname;
            this.changedFields = changedFields.add("parententitylogicalname");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder canstorefullimage(Boolean canstorefullimage) {
            this.canstorefullimage = canstorefullimage;
            this.changedFields = changedFields.add("canstorefullimage");
            return this;
        }

        public Builder attributeimageconfigid(String attributeimageconfigid) {
            this.attributeimageconfigid = attributeimageconfigid;
            this.changedFields = changedFields.add("attributeimageconfigid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder attributelogicalname(String attributelogicalname) {
            this.attributelogicalname = attributelogicalname;
            this.changedFields = changedFields.add("attributelogicalname");
            return this;
        }

        public Attributeimageconfig build() {
            Attributeimageconfig _x = new Attributeimageconfig();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.attributeimageconfig";
            _x.componentidunique = componentidunique;
            _x.versionnumber = versionnumber;
            _x.solutionid = solutionid;
            _x.componentstate = componentstate;
            _x.parententitylogicalname = parententitylogicalname;
            _x.ismanaged = ismanaged;
            _x.canstorefullimage = canstorefullimage;
            _x.attributeimageconfigid = attributeimageconfigid;
            _x.overwritetime = overwritetime;
            _x.attributelogicalname = attributelogicalname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && attributeimageconfigid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(attributeimageconfigid.toString()));
        }
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<String> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Attributeimageconfig withComponentidunique(String componentidunique) {
        Attributeimageconfig _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attributeimageconfig");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Attributeimageconfig withVersionnumber(Long versionnumber) {
        Attributeimageconfig _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attributeimageconfig");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Attributeimageconfig withSolutionid(String solutionid) {
        Attributeimageconfig _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attributeimageconfig");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Attributeimageconfig withComponentstate(Integer componentstate) {
        Attributeimageconfig _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attributeimageconfig");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="parententitylogicalname")
    @JsonIgnore
    public Optional<String> getParententitylogicalname() {
        return Optional.ofNullable(parententitylogicalname);
    }

    public Attributeimageconfig withParententitylogicalname(String parententitylogicalname) {
        Checks.checkIsAscii(parententitylogicalname);
        Attributeimageconfig _x = _copy();
        _x.changedFields = changedFields.add("parententitylogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attributeimageconfig");
        _x.parententitylogicalname = parententitylogicalname;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Attributeimageconfig withIsmanaged(Boolean ismanaged) {
        Attributeimageconfig _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attributeimageconfig");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="canstorefullimage")
    @JsonIgnore
    public Optional<Boolean> getCanstorefullimage() {
        return Optional.ofNullable(canstorefullimage);
    }

    public Attributeimageconfig withCanstorefullimage(Boolean canstorefullimage) {
        Attributeimageconfig _x = _copy();
        _x.changedFields = changedFields.add("canstorefullimage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attributeimageconfig");
        _x.canstorefullimage = canstorefullimage;
        return _x;
    }

    @Property(name="attributeimageconfigid")
    @JsonIgnore
    public Optional<String> getAttributeimageconfigid() {
        return Optional.ofNullable(attributeimageconfigid);
    }

    public Attributeimageconfig withAttributeimageconfigid(String attributeimageconfigid) {
        Attributeimageconfig _x = _copy();
        _x.changedFields = changedFields.add("attributeimageconfigid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attributeimageconfig");
        _x.attributeimageconfigid = attributeimageconfigid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Attributeimageconfig withOverwritetime(OffsetDateTime overwritetime) {
        Attributeimageconfig _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attributeimageconfig");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="attributelogicalname")
    @JsonIgnore
    public Optional<String> getAttributelogicalname() {
        return Optional.ofNullable(attributelogicalname);
    }

    public Attributeimageconfig withAttributelogicalname(String attributelogicalname) {
        Checks.checkIsAscii(attributelogicalname);
        Attributeimageconfig _x = _copy();
        _x.changedFields = changedFields.add("attributelogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attributeimageconfig");
        _x.attributelogicalname = attributelogicalname;
        return _x;
    }

    public Attributeimageconfig withUnmappedField(String name, String value) {
        Attributeimageconfig _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="attributeimageconfig_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getAttributeimageconfig_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("attributeimageconfig_SyncErrors"), RequestHelper.getValue(unmappedFields, "attributeimageconfig_SyncErrors"));
    }

    @NavigationProperty(name="attributeimageconfig_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getAttributeimageconfig_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("attributeimageconfig_AsyncOperations"), RequestHelper.getValue(unmappedFields, "attributeimageconfig_AsyncOperations"));
    }

    @NavigationProperty(name="attributeimageconfig_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getAttributeimageconfig_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("attributeimageconfig_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "attributeimageconfig_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="attributeimageconfig_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getAttributeimageconfig_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("attributeimageconfig_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "attributeimageconfig_BulkDeleteFailures"));
    }

    @NavigationProperty(name="attributeimageconfig_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getAttributeimageconfig_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("attributeimageconfig_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "attributeimageconfig_PrincipalObjectAttributeAccesses"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Attributeimageconfig patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Attributeimageconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Attributeimageconfig put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Attributeimageconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Attributeimageconfig _copy() {
        Attributeimageconfig _x = new Attributeimageconfig();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentidunique = componentidunique;
        _x.versionnumber = versionnumber;
        _x.solutionid = solutionid;
        _x.componentstate = componentstate;
        _x.parententitylogicalname = parententitylogicalname;
        _x.ismanaged = ismanaged;
        _x.canstorefullimage = canstorefullimage;
        _x.attributeimageconfigid = attributeimageconfigid;
        _x.overwritetime = overwritetime;
        _x.attributelogicalname = attributelogicalname;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Attributeimageconfig[");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("parententitylogicalname=");
        b.append(this.parententitylogicalname);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("canstorefullimage=");
        b.append(this.canstorefullimage);
        b.append(", ");
        b.append("attributeimageconfigid=");
        b.append(this.attributeimageconfigid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("attributelogicalname=");
        b.append(this.attributelogicalname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
