package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitymimeattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "subscriptionid", 
    "category", 
    "isdraft", 
    "location", 
    "originalstartdate", 
    "outlookownerapptid", 
    "isunsafe", 
    "isalldayevent", 
    "attachmenterrors", 
    "subcategory", 
    "importsequencenumber", 
    "modifiedfieldsmask", 
    "globalobjectid", 
    "overriddencreatedon"})
@JsonInclude(Include.NON_NULL)
public class Appointment extends Activitypointer implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.appointment";
    }

    @JsonProperty("subscriptionid")
    protected String subscriptionid;

    @JsonProperty("category")
    protected String category;

    @JsonProperty("isdraft")
    protected Boolean isdraft;

    @JsonProperty("location")
    protected String location;

    @JsonProperty("originalstartdate")
    protected OffsetDateTime originalstartdate;

    @JsonProperty("outlookownerapptid")
    protected Integer outlookownerapptid;

    @JsonProperty("isunsafe")
    protected Integer isunsafe;

    @JsonProperty("isalldayevent")
    protected Boolean isalldayevent;

    @JsonProperty("attachmenterrors")
    protected Integer attachmenterrors;

    @JsonProperty("subcategory")
    protected String subcategory;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("modifiedfieldsmask")
    protected String modifiedfieldsmask;

    @JsonProperty("globalobjectid")
    protected String globalobjectid;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    protected Appointment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppointment() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastonholdtime;
        private Integer actualdurationminutes;
        private String _owningteam_value;
        private String exchangeitemid;
        private Boolean ismapiprivate;
        private OffsetDateTime createdon;
        private String seriesid;
        private Boolean leftvoicemail;
        private OffsetDateTime deliverylastattemptedon;
        private Boolean isbilled;
        private Boolean isworkflowcreated;
        private String _sendermailboxid_value;
        private String description;
        private String _regardingobjectid_value;
        private Integer onholdtime;
        private String _modifiedby_value;
        private Integer community;
        private String activityid;
        private OffsetDateTime sortdate;
        private Integer instancetypecode;
        private Integer timezoneruleversionnumber;
        private String _createdonbehalfby_value;
        private String _transactioncurrencyid_value;
        private Long versionnumber;
        private String processid;
        private OffsetDateTime scheduledend;
        private Integer prioritycode;
        private String _slaid_value;
        private String stageid;
        private OffsetDateTime actualstart;
        private String _owningbusinessunit_value;
        private String _owninguser_value;
        private Integer utcconversiontimezonecode;
        private String exchangeweblink;
        private Integer scheduleddurationminutes;
        private OffsetDateTime senton;
        private OffsetDateTime scheduledstart;
        private Integer statecode;
        private String subject;
        private OffsetDateTime postponeactivityprocessinguntil;
        private String _modifiedonbehalfby_value;
        private BigDecimal exchangerate;
        private Boolean isregularactivity;
        private Integer deliveryprioritycode;
        private String activityadditionalparams;
        private String traversedpath;
        private String _createdby_value;
        private String activitytypecode;
        private String _ownerid_value;
        private OffsetDateTime modifiedon;
        private String _slainvokedid_value;
        private Integer statuscode;
        private OffsetDateTime actualend;
        private String subscriptionid;
        private String category;
        private Boolean isdraft;
        private String location;
        private OffsetDateTime originalstartdate;
        private Integer outlookownerapptid;
        private Integer isunsafe;
        private Boolean isalldayevent;
        private Integer attachmenterrors;
        private String subcategory;
        private Integer importsequencenumber;
        private String modifiedfieldsmask;
        private String globalobjectid;
        private OffsetDateTime overriddencreatedon;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder lastonholdtime(OffsetDateTime lastonholdtime) {
            this.lastonholdtime = lastonholdtime;
            this.changedFields = changedFields.add("lastonholdtime");
            return this;
        }

        public Builder actualdurationminutes(Integer actualdurationminutes) {
            this.actualdurationminutes = actualdurationminutes;
            this.changedFields = changedFields.add("actualdurationminutes");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder exchangeitemid(String exchangeitemid) {
            this.exchangeitemid = exchangeitemid;
            this.changedFields = changedFields.add("exchangeitemid");
            return this;
        }

        public Builder ismapiprivate(Boolean ismapiprivate) {
            this.ismapiprivate = ismapiprivate;
            this.changedFields = changedFields.add("ismapiprivate");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder seriesid(String seriesid) {
            this.seriesid = seriesid;
            this.changedFields = changedFields.add("seriesid");
            return this;
        }

        public Builder leftvoicemail(Boolean leftvoicemail) {
            this.leftvoicemail = leftvoicemail;
            this.changedFields = changedFields.add("leftvoicemail");
            return this;
        }

        public Builder deliverylastattemptedon(OffsetDateTime deliverylastattemptedon) {
            this.deliverylastattemptedon = deliverylastattemptedon;
            this.changedFields = changedFields.add("deliverylastattemptedon");
            return this;
        }

        public Builder isbilled(Boolean isbilled) {
            this.isbilled = isbilled;
            this.changedFields = changedFields.add("isbilled");
            return this;
        }

        public Builder isworkflowcreated(Boolean isworkflowcreated) {
            this.isworkflowcreated = isworkflowcreated;
            this.changedFields = changedFields.add("isworkflowcreated");
            return this;
        }

        public Builder _sendermailboxid_value(String _sendermailboxid_value) {
            this._sendermailboxid_value = _sendermailboxid_value;
            this.changedFields = changedFields.add("_sendermailboxid_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _regardingobjectid_value(String _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder onholdtime(Integer onholdtime) {
            this.onholdtime = onholdtime;
            this.changedFields = changedFields.add("onholdtime");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder community(Integer community) {
            this.community = community;
            this.changedFields = changedFields.add("community");
            return this;
        }

        public Builder activityid(String activityid) {
            this.activityid = activityid;
            this.changedFields = changedFields.add("activityid");
            return this;
        }

        public Builder sortdate(OffsetDateTime sortdate) {
            this.sortdate = sortdate;
            this.changedFields = changedFields.add("sortdate");
            return this;
        }

        public Builder instancetypecode(Integer instancetypecode) {
            this.instancetypecode = instancetypecode;
            this.changedFields = changedFields.add("instancetypecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder processid(String processid) {
            this.processid = processid;
            this.changedFields = changedFields.add("processid");
            return this;
        }

        public Builder scheduledend(OffsetDateTime scheduledend) {
            this.scheduledend = scheduledend;
            this.changedFields = changedFields.add("scheduledend");
            return this;
        }

        public Builder prioritycode(Integer prioritycode) {
            this.prioritycode = prioritycode;
            this.changedFields = changedFields.add("prioritycode");
            return this;
        }

        public Builder _slaid_value(String _slaid_value) {
            this._slaid_value = _slaid_value;
            this.changedFields = changedFields.add("_slaid_value");
            return this;
        }

        public Builder stageid(String stageid) {
            this.stageid = stageid;
            this.changedFields = changedFields.add("stageid");
            return this;
        }

        public Builder actualstart(OffsetDateTime actualstart) {
            this.actualstart = actualstart;
            this.changedFields = changedFields.add("actualstart");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder exchangeweblink(String exchangeweblink) {
            this.exchangeweblink = exchangeweblink;
            this.changedFields = changedFields.add("exchangeweblink");
            return this;
        }

        public Builder scheduleddurationminutes(Integer scheduleddurationminutes) {
            this.scheduleddurationminutes = scheduleddurationminutes;
            this.changedFields = changedFields.add("scheduleddurationminutes");
            return this;
        }

        public Builder senton(OffsetDateTime senton) {
            this.senton = senton;
            this.changedFields = changedFields.add("senton");
            return this;
        }

        public Builder scheduledstart(OffsetDateTime scheduledstart) {
            this.scheduledstart = scheduledstart;
            this.changedFields = changedFields.add("scheduledstart");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder postponeactivityprocessinguntil(OffsetDateTime postponeactivityprocessinguntil) {
            this.postponeactivityprocessinguntil = postponeactivityprocessinguntil;
            this.changedFields = changedFields.add("postponeactivityprocessinguntil");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder isregularactivity(Boolean isregularactivity) {
            this.isregularactivity = isregularactivity;
            this.changedFields = changedFields.add("isregularactivity");
            return this;
        }

        public Builder deliveryprioritycode(Integer deliveryprioritycode) {
            this.deliveryprioritycode = deliveryprioritycode;
            this.changedFields = changedFields.add("deliveryprioritycode");
            return this;
        }

        public Builder activityadditionalparams(String activityadditionalparams) {
            this.activityadditionalparams = activityadditionalparams;
            this.changedFields = changedFields.add("activityadditionalparams");
            return this;
        }

        public Builder traversedpath(String traversedpath) {
            this.traversedpath = traversedpath;
            this.changedFields = changedFields.add("traversedpath");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder activitytypecode(String activitytypecode) {
            this.activitytypecode = activitytypecode;
            this.changedFields = changedFields.add("activitytypecode");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _slainvokedid_value(String _slainvokedid_value) {
            this._slainvokedid_value = _slainvokedid_value;
            this.changedFields = changedFields.add("_slainvokedid_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder actualend(OffsetDateTime actualend) {
            this.actualend = actualend;
            this.changedFields = changedFields.add("actualend");
            return this;
        }

        public Builder subscriptionid(String subscriptionid) {
            this.subscriptionid = subscriptionid;
            this.changedFields = changedFields.add("subscriptionid");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder isdraft(Boolean isdraft) {
            this.isdraft = isdraft;
            this.changedFields = changedFields.add("isdraft");
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder originalstartdate(OffsetDateTime originalstartdate) {
            this.originalstartdate = originalstartdate;
            this.changedFields = changedFields.add("originalstartdate");
            return this;
        }

        public Builder outlookownerapptid(Integer outlookownerapptid) {
            this.outlookownerapptid = outlookownerapptid;
            this.changedFields = changedFields.add("outlookownerapptid");
            return this;
        }

        public Builder isunsafe(Integer isunsafe) {
            this.isunsafe = isunsafe;
            this.changedFields = changedFields.add("isunsafe");
            return this;
        }

        public Builder isalldayevent(Boolean isalldayevent) {
            this.isalldayevent = isalldayevent;
            this.changedFields = changedFields.add("isalldayevent");
            return this;
        }

        public Builder attachmenterrors(Integer attachmenterrors) {
            this.attachmenterrors = attachmenterrors;
            this.changedFields = changedFields.add("attachmenterrors");
            return this;
        }

        public Builder subcategory(String subcategory) {
            this.subcategory = subcategory;
            this.changedFields = changedFields.add("subcategory");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder modifiedfieldsmask(String modifiedfieldsmask) {
            this.modifiedfieldsmask = modifiedfieldsmask;
            this.changedFields = changedFields.add("modifiedfieldsmask");
            return this;
        }

        public Builder globalobjectid(String globalobjectid) {
            this.globalobjectid = globalobjectid;
            this.changedFields = changedFields.add("globalobjectid");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Appointment build() {
            Appointment _x = new Appointment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.appointment";
            _x.lastonholdtime = lastonholdtime;
            _x.actualdurationminutes = actualdurationminutes;
            _x._owningteam_value = _owningteam_value;
            _x.exchangeitemid = exchangeitemid;
            _x.ismapiprivate = ismapiprivate;
            _x.createdon = createdon;
            _x.seriesid = seriesid;
            _x.leftvoicemail = leftvoicemail;
            _x.deliverylastattemptedon = deliverylastattemptedon;
            _x.isbilled = isbilled;
            _x.isworkflowcreated = isworkflowcreated;
            _x._sendermailboxid_value = _sendermailboxid_value;
            _x.description = description;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.onholdtime = onholdtime;
            _x._modifiedby_value = _modifiedby_value;
            _x.community = community;
            _x.activityid = activityid;
            _x.sortdate = sortdate;
            _x.instancetypecode = instancetypecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.versionnumber = versionnumber;
            _x.processid = processid;
            _x.scheduledend = scheduledend;
            _x.prioritycode = prioritycode;
            _x._slaid_value = _slaid_value;
            _x.stageid = stageid;
            _x.actualstart = actualstart;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._owninguser_value = _owninguser_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.exchangeweblink = exchangeweblink;
            _x.scheduleddurationminutes = scheduleddurationminutes;
            _x.senton = senton;
            _x.scheduledstart = scheduledstart;
            _x.statecode = statecode;
            _x.subject = subject;
            _x.postponeactivityprocessinguntil = postponeactivityprocessinguntil;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.exchangerate = exchangerate;
            _x.isregularactivity = isregularactivity;
            _x.deliveryprioritycode = deliveryprioritycode;
            _x.activityadditionalparams = activityadditionalparams;
            _x.traversedpath = traversedpath;
            _x._createdby_value = _createdby_value;
            _x.activitytypecode = activitytypecode;
            _x._ownerid_value = _ownerid_value;
            _x.modifiedon = modifiedon;
            _x._slainvokedid_value = _slainvokedid_value;
            _x.statuscode = statuscode;
            _x.actualend = actualend;
            _x.subscriptionid = subscriptionid;
            _x.category = category;
            _x.isdraft = isdraft;
            _x.location = location;
            _x.originalstartdate = originalstartdate;
            _x.outlookownerapptid = outlookownerapptid;
            _x.isunsafe = isunsafe;
            _x.isalldayevent = isalldayevent;
            _x.attachmenterrors = attachmenterrors;
            _x.subcategory = subcategory;
            _x.importsequencenumber = importsequencenumber;
            _x.modifiedfieldsmask = modifiedfieldsmask;
            _x.globalobjectid = globalobjectid;
            _x.overriddencreatedon = overriddencreatedon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && activityid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(activityid.toString()));
        }
    }

    @Property(name="subscriptionid")
    @JsonIgnore
    public Optional<String> getSubscriptionid() {
        return Optional.ofNullable(subscriptionid);
    }

    public Appointment withSubscriptionid(String subscriptionid) {
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("subscriptionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.subscriptionid = subscriptionid;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    public Appointment withCategory(String category) {
        Checks.checkIsAscii(category);
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.category = category;
        return _x;
    }

    @Property(name="isdraft")
    @JsonIgnore
    public Optional<Boolean> getIsdraft() {
        return Optional.ofNullable(isdraft);
    }

    public Appointment withIsdraft(Boolean isdraft) {
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("isdraft");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.isdraft = isdraft;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<String> getLocation() {
        return Optional.ofNullable(location);
    }

    public Appointment withLocation(String location) {
        Checks.checkIsAscii(location);
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.location = location;
        return _x;
    }

    @Property(name="originalstartdate")
    @JsonIgnore
    public Optional<OffsetDateTime> getOriginalstartdate() {
        return Optional.ofNullable(originalstartdate);
    }

    public Appointment withOriginalstartdate(OffsetDateTime originalstartdate) {
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("originalstartdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.originalstartdate = originalstartdate;
        return _x;
    }

    @Property(name="outlookownerapptid")
    @JsonIgnore
    public Optional<Integer> getOutlookownerapptid() {
        return Optional.ofNullable(outlookownerapptid);
    }

    public Appointment withOutlookownerapptid(Integer outlookownerapptid) {
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("outlookownerapptid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.outlookownerapptid = outlookownerapptid;
        return _x;
    }

    @Property(name="isunsafe")
    @JsonIgnore
    public Optional<Integer> getIsunsafe() {
        return Optional.ofNullable(isunsafe);
    }

    public Appointment withIsunsafe(Integer isunsafe) {
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("isunsafe");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.isunsafe = isunsafe;
        return _x;
    }

    @Property(name="isalldayevent")
    @JsonIgnore
    public Optional<Boolean> getIsalldayevent() {
        return Optional.ofNullable(isalldayevent);
    }

    public Appointment withIsalldayevent(Boolean isalldayevent) {
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("isalldayevent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.isalldayevent = isalldayevent;
        return _x;
    }

    @Property(name="attachmenterrors")
    @JsonIgnore
    public Optional<Integer> getAttachmenterrors() {
        return Optional.ofNullable(attachmenterrors);
    }

    public Appointment withAttachmenterrors(Integer attachmenterrors) {
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("attachmenterrors");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.attachmenterrors = attachmenterrors;
        return _x;
    }

    @Property(name="subcategory")
    @JsonIgnore
    public Optional<String> getSubcategory() {
        return Optional.ofNullable(subcategory);
    }

    public Appointment withSubcategory(String subcategory) {
        Checks.checkIsAscii(subcategory);
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("subcategory");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.subcategory = subcategory;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Appointment withImportsequencenumber(Integer importsequencenumber) {
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="modifiedfieldsmask")
    @JsonIgnore
    public Optional<String> getModifiedfieldsmask() {
        return Optional.ofNullable(modifiedfieldsmask);
    }

    public Appointment withModifiedfieldsmask(String modifiedfieldsmask) {
        Checks.checkIsAscii(modifiedfieldsmask);
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("modifiedfieldsmask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.modifiedfieldsmask = modifiedfieldsmask;
        return _x;
    }

    @Property(name="globalobjectid")
    @JsonIgnore
    public Optional<String> getGlobalobjectid() {
        return Optional.ofNullable(globalobjectid);
    }

    public Appointment withGlobalobjectid(String globalobjectid) {
        Checks.checkIsAscii(globalobjectid);
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("globalobjectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.globalobjectid = globalobjectid;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Appointment withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Appointment _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appointment");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    public Appointment withUnmappedField(String name, String value) {
        Appointment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appointment_PostRegardings")
    @JsonIgnore
    public PostregardingCollectionRequest getAppointment_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("appointment_PostRegardings"), RequestHelper.getValue(unmappedFields, "appointment_PostRegardings"));
    }

    @NavigationProperty(name="appointment_PostFollows")
    @JsonIgnore
    public PostfollowCollectionRequest getAppointment_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("appointment_PostFollows"), RequestHelper.getValue(unmappedFields, "appointment_PostFollows"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgebaserecord_appointment")
    @JsonIgnore
    public KnowledgebaserecordRequest getRegardingobjectid_knowledgebaserecord_appointment() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord_appointment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgebaserecord_appointment"));
    }

    @NavigationProperty(name="Appointment_QueueItem")
    @JsonIgnore
    public QueueitemCollectionRequest getAppointment_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("Appointment_QueueItem"), RequestHelper.getValue(unmappedFields, "Appointment_QueueItem"));
    }

    @NavigationProperty(name="Appointment_Annotation")
    @JsonIgnore
    public AnnotationCollectionRequest getAppointment_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("Appointment_Annotation"), RequestHelper.getValue(unmappedFields, "Appointment_Annotation"));
    }

    @NavigationProperty(name="Appointment_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getAppointment_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Appointment_SyncErrors"), RequestHelper.getValue(unmappedFields, "Appointment_SyncErrors"));
    }

    @NavigationProperty(name="stageid_processstage")
    @JsonIgnore
    public ProcessstageRequest getStageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), RequestHelper.getValue(unmappedFields, "stageid_processstage"));
    }

    @NavigationProperty(name="seriesid_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getSeriesid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("seriesid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "seriesid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="owningbusinessunit_appointment")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit_appointment() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit_appointment"), RequestHelper.getValue(unmappedFields, "owningbusinessunit_appointment"));
    }

    @NavigationProperty(name="Appointment_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getAppointment_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Appointment_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "Appointment_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="appointment_activity_parties")
    @JsonIgnore
    public ActivitypartyCollectionRequest getAppointment_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("appointment_activity_parties"), RequestHelper.getValue(unmappedFields, "appointment_activity_parties"));
    }

    @NavigationProperty(name="Appointment_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getAppointment_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Appointment_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Appointment_AsyncOperations"));
    }

    @NavigationProperty(name="modifiedonbehalfby_appointment")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby_appointment() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby_appointment"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby_appointment"));
    }

    @NavigationProperty(name="Appointment_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getAppointment_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Appointment_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "Appointment_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="appointment_connections1")
    @JsonIgnore
    public ConnectionCollectionRequest getAppointment_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("appointment_connections1"), RequestHelper.getValue(unmappedFields, "appointment_connections1"));
    }

    @NavigationProperty(name="slakpiinstance_appointment")
    @JsonIgnore
    public SlakpiinstanceCollectionRequest getSlakpiinstance_appointment() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_appointment"), RequestHelper.getValue(unmappedFields, "slakpiinstance_appointment"));
    }

    @NavigationProperty(name="modifiedby_appointment")
    @JsonIgnore
    public SystemuserRequest getModifiedby_appointment() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby_appointment"), RequestHelper.getValue(unmappedFields, "modifiedby_appointment"));
    }

    @NavigationProperty(name="appointment_activity_mime_attachment")
    @JsonIgnore
    public ActivitymimeattachmentCollectionRequest getAppointment_activity_mime_attachment() {
        return new ActivitymimeattachmentCollectionRequest(
                        contextPath.addSegment("appointment_activity_mime_attachment"), RequestHelper.getValue(unmappedFields, "appointment_activity_mime_attachment"));
    }

    @NavigationProperty(name="Appointment_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getAppointment_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Appointment_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Appointment_BulkDeleteFailures"));
    }

    @NavigationProperty(name="appointment_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getAppointment_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("appointment_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "appointment_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="appointment_connections2")
    @JsonIgnore
    public ConnectionCollectionRequest getAppointment_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("appointment_connections2"), RequestHelper.getValue(unmappedFields, "appointment_connections2"));
    }

    @NavigationProperty(name="appointment_actioncard")
    @JsonIgnore
    public ActioncardCollectionRequest getAppointment_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("appointment_actioncard"), RequestHelper.getValue(unmappedFields, "appointment_actioncard"));
    }

    @NavigationProperty(name="sla_appointment_sla")
    @JsonIgnore
    public SlaRequest getSla_appointment_sla() {
        return new SlaRequest(contextPath.addSegment("sla_appointment_sla"), RequestHelper.getValue(unmappedFields, "sla_appointment_sla"));
    }

    @NavigationProperty(name="Appointment_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getAppointment_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Appointment_ProcessSessions"), RequestHelper.getValue(unmappedFields, "Appointment_ProcessSessions"));
    }

    @NavigationProperty(name="regardingobjectid_contact_appointment")
    @JsonIgnore
    public ContactRequest getRegardingobjectid_contact_appointment() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_appointment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_contact_appointment"));
    }

    @NavigationProperty(name="createdonbehalfby_appointment")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby_appointment() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby_appointment"), RequestHelper.getValue(unmappedFields, "createdonbehalfby_appointment"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgearticle_appointment")
    @JsonIgnore
    public KnowledgearticleRequest getRegardingobjectid_knowledgearticle_appointment() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle_appointment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgearticle_appointment"));
    }

    @NavigationProperty(name="regardingobjectid_account_appointment")
    @JsonIgnore
    public AccountRequest getRegardingobjectid_account_appointment() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_appointment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_account_appointment"));
    }

    @NavigationProperty(name="activityid_activitypointer")
    @JsonIgnore
    public ActivitypointerRequest getActivityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), RequestHelper.getValue(unmappedFields, "activityid_activitypointer"));
    }

    @NavigationProperty(name="transactioncurrencyid_appointment")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid_appointment() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid_appointment"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid_appointment"));
    }

    @NavigationProperty(name="slainvokedid_appointment_sla")
    @JsonIgnore
    public SlaRequest getSlainvokedid_appointment_sla() {
        return new SlaRequest(contextPath.addSegment("slainvokedid_appointment_sla"), RequestHelper.getValue(unmappedFields, "slainvokedid_appointment_sla"));
    }

    @NavigationProperty(name="createdby_appointment")
    @JsonIgnore
    public SystemuserRequest getCreatedby_appointment() {
        return new SystemuserRequest(contextPath.addSegment("createdby_appointment"), RequestHelper.getValue(unmappedFields, "createdby_appointment"));
    }

    @NavigationProperty(name="owningteam_appointment")
    @JsonIgnore
    public TeamRequest getOwningteam_appointment() {
        return new TeamRequest(contextPath.addSegment("owningteam_appointment"), RequestHelper.getValue(unmappedFields, "owningteam_appointment"));
    }

    @NavigationProperty(name="owninguser_appointment")
    @JsonIgnore
    public SystemuserRequest getOwninguser_appointment() {
        return new SystemuserRequest(contextPath.addSegment("owninguser_appointment"), RequestHelper.getValue(unmappedFields, "owninguser_appointment"));
    }

    @NavigationProperty(name="ownerid_appointment")
    @JsonIgnore
    public PrincipalRequest getOwnerid_appointment() {
        return new PrincipalRequest(contextPath.addSegment("ownerid_appointment"), RequestHelper.getValue(unmappedFields, "ownerid_appointment"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appointment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Appointment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appointment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Appointment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Appointment _copy() {
        Appointment _x = new Appointment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lastonholdtime = lastonholdtime;
        _x.actualdurationminutes = actualdurationminutes;
        _x._owningteam_value = _owningteam_value;
        _x.exchangeitemid = exchangeitemid;
        _x.ismapiprivate = ismapiprivate;
        _x.createdon = createdon;
        _x.seriesid = seriesid;
        _x.leftvoicemail = leftvoicemail;
        _x.deliverylastattemptedon = deliverylastattemptedon;
        _x.isbilled = isbilled;
        _x.isworkflowcreated = isworkflowcreated;
        _x._sendermailboxid_value = _sendermailboxid_value;
        _x.description = description;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.onholdtime = onholdtime;
        _x._modifiedby_value = _modifiedby_value;
        _x.community = community;
        _x.activityid = activityid;
        _x.sortdate = sortdate;
        _x.instancetypecode = instancetypecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.versionnumber = versionnumber;
        _x.processid = processid;
        _x.scheduledend = scheduledend;
        _x.prioritycode = prioritycode;
        _x._slaid_value = _slaid_value;
        _x.stageid = stageid;
        _x.actualstart = actualstart;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._owninguser_value = _owninguser_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.exchangeweblink = exchangeweblink;
        _x.scheduleddurationminutes = scheduleddurationminutes;
        _x.senton = senton;
        _x.scheduledstart = scheduledstart;
        _x.statecode = statecode;
        _x.subject = subject;
        _x.postponeactivityprocessinguntil = postponeactivityprocessinguntil;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.exchangerate = exchangerate;
        _x.isregularactivity = isregularactivity;
        _x.deliveryprioritycode = deliveryprioritycode;
        _x.activityadditionalparams = activityadditionalparams;
        _x.traversedpath = traversedpath;
        _x._createdby_value = _createdby_value;
        _x.activitytypecode = activitytypecode;
        _x._ownerid_value = _ownerid_value;
        _x.modifiedon = modifiedon;
        _x._slainvokedid_value = _slainvokedid_value;
        _x.statuscode = statuscode;
        _x.actualend = actualend;
        _x.subscriptionid = subscriptionid;
        _x.category = category;
        _x.isdraft = isdraft;
        _x.location = location;
        _x.originalstartdate = originalstartdate;
        _x.outlookownerapptid = outlookownerapptid;
        _x.isunsafe = isunsafe;
        _x.isalldayevent = isalldayevent;
        _x.attachmenterrors = attachmenterrors;
        _x.subcategory = subcategory;
        _x.importsequencenumber = importsequencenumber;
        _x.modifiedfieldsmask = modifiedfieldsmask;
        _x.globalobjectid = globalobjectid;
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Action(name = "AddRecurrence")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Recurringappointmentmaster> addRecurrence(Recurringappointmentmaster target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.recurringappointmentmaster", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Recurringappointmentmaster>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddRecurrence"), Recurringappointmentmaster.class, _parameters, microsoft.dynamics.crm.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Appointment[");
        b.append("lastonholdtime=");
        b.append(this.lastonholdtime);
        b.append(", ");
        b.append("actualdurationminutes=");
        b.append(this.actualdurationminutes);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("exchangeitemid=");
        b.append(this.exchangeitemid);
        b.append(", ");
        b.append("ismapiprivate=");
        b.append(this.ismapiprivate);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("seriesid=");
        b.append(this.seriesid);
        b.append(", ");
        b.append("leftvoicemail=");
        b.append(this.leftvoicemail);
        b.append(", ");
        b.append("deliverylastattemptedon=");
        b.append(this.deliverylastattemptedon);
        b.append(", ");
        b.append("isbilled=");
        b.append(this.isbilled);
        b.append(", ");
        b.append("isworkflowcreated=");
        b.append(this.isworkflowcreated);
        b.append(", ");
        b.append("_sendermailboxid_value=");
        b.append(this._sendermailboxid_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("onholdtime=");
        b.append(this.onholdtime);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("community=");
        b.append(this.community);
        b.append(", ");
        b.append("activityid=");
        b.append(this.activityid);
        b.append(", ");
        b.append("sortdate=");
        b.append(this.sortdate);
        b.append(", ");
        b.append("instancetypecode=");
        b.append(this.instancetypecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("processid=");
        b.append(this.processid);
        b.append(", ");
        b.append("scheduledend=");
        b.append(this.scheduledend);
        b.append(", ");
        b.append("prioritycode=");
        b.append(this.prioritycode);
        b.append(", ");
        b.append("_slaid_value=");
        b.append(this._slaid_value);
        b.append(", ");
        b.append("stageid=");
        b.append(this.stageid);
        b.append(", ");
        b.append("actualstart=");
        b.append(this.actualstart);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("exchangeweblink=");
        b.append(this.exchangeweblink);
        b.append(", ");
        b.append("scheduleddurationminutes=");
        b.append(this.scheduleddurationminutes);
        b.append(", ");
        b.append("senton=");
        b.append(this.senton);
        b.append(", ");
        b.append("scheduledstart=");
        b.append(this.scheduledstart);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("postponeactivityprocessinguntil=");
        b.append(this.postponeactivityprocessinguntil);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("isregularactivity=");
        b.append(this.isregularactivity);
        b.append(", ");
        b.append("deliveryprioritycode=");
        b.append(this.deliveryprioritycode);
        b.append(", ");
        b.append("activityadditionalparams=");
        b.append(this.activityadditionalparams);
        b.append(", ");
        b.append("traversedpath=");
        b.append(this.traversedpath);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("activitytypecode=");
        b.append(this.activitytypecode);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_slainvokedid_value=");
        b.append(this._slainvokedid_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("actualend=");
        b.append(this.actualend);
        b.append(", ");
        b.append("subscriptionid=");
        b.append(this.subscriptionid);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("isdraft=");
        b.append(this.isdraft);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("originalstartdate=");
        b.append(this.originalstartdate);
        b.append(", ");
        b.append("outlookownerapptid=");
        b.append(this.outlookownerapptid);
        b.append(", ");
        b.append("isunsafe=");
        b.append(this.isunsafe);
        b.append(", ");
        b.append("isalldayevent=");
        b.append(this.isalldayevent);
        b.append(", ");
        b.append("attachmenterrors=");
        b.append(this.attachmenterrors);
        b.append(", ");
        b.append("subcategory=");
        b.append(this.subcategory);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("modifiedfieldsmask=");
        b.append(this.modifiedfieldsmask);
        b.append(", ");
        b.append("globalobjectid=");
        b.append(this.globalobjectid);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
