package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "ServicePlans"})
@JsonInclude(Include.NON_NULL)
public class UserLicenseInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ServicePlans")
    protected List<ServicePlan> servicePlans;

    @JsonProperty("ServicePlans@nextLink")
    protected String servicePlansNextLink;

    protected UserLicenseInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.UserLicenseInfo";
    }

    @Property(name="ServicePlans")
    @JsonIgnore
    public CollectionPage<ServicePlan> getServicePlans() {
        return new CollectionPage<ServicePlan>(contextPath, ServicePlan.class, this.servicePlans, Optional.ofNullable(servicePlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ServicePlans")
    @JsonIgnore
    public CollectionPage<ServicePlan> getServicePlans(HttpRequestOptions options) {
        return new CollectionPage<ServicePlan>(contextPath, ServicePlan.class, this.servicePlans, Optional.ofNullable(servicePlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    public UserLicenseInfo withUnmappedField(String name, String value) {
        UserLicenseInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ServicePlan> servicePlans;
        private String servicePlansNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder servicePlans(List<ServicePlan> servicePlans) {
            this.servicePlans = servicePlans;
            this.changedFields = changedFields.add("ServicePlans");
            return this;
        }

        public Builder servicePlans(ServicePlan... servicePlans) {
            return servicePlans(Arrays.asList(servicePlans));
        }

        public Builder servicePlansNextLink(String servicePlansNextLink) {
            this.servicePlansNextLink = servicePlansNextLink;
            this.changedFields = changedFields.add("ServicePlans");
            return this;
        }

        public UserLicenseInfo build() {
            UserLicenseInfo _x = new UserLicenseInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.UserLicenseInfo";
            _x.servicePlans = servicePlans;
            _x.servicePlansNextLink = servicePlansNextLink;
            return _x;
        }
    }

    private UserLicenseInfo _copy() {
        UserLicenseInfo _x = new UserLicenseInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.servicePlans = servicePlans;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserLicenseInfo[");
        b.append("ServicePlans=");
        b.append(this.servicePlans);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
