package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.enums.AccessRights;

@JsonPropertyOrder({
    "@odata.type", 
    "OldPrivileges", 
    "NewPrivileges"})
@JsonInclude(Include.NON_NULL)
public class ShareAuditDetail extends AuditDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("OldPrivileges")
    protected AccessRights oldPrivileges;

    @JsonProperty("NewPrivileges")
    protected AccessRights newPrivileges;

    protected ShareAuditDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ShareAuditDetail";
    }

    @Property(name="OldPrivileges")
    @JsonIgnore
    public Optional<AccessRights> getOldPrivileges() {
        return Optional.ofNullable(oldPrivileges);
    }

    public ShareAuditDetail withOldPrivileges(AccessRights oldPrivileges) {
        ShareAuditDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ShareAuditDetail");
        _x.oldPrivileges = oldPrivileges;
        return _x;
    }

    @Property(name="NewPrivileges")
    @JsonIgnore
    public Optional<AccessRights> getNewPrivileges() {
        return Optional.ofNullable(newPrivileges);
    }

    public ShareAuditDetail withNewPrivileges(AccessRights newPrivileges) {
        ShareAuditDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ShareAuditDetail");
        _x.newPrivileges = newPrivileges;
        return _x;
    }

    public ShareAuditDetail withUnmappedField(String name, String value) {
        ShareAuditDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderShareAuditDetail() {
        return new Builder();
    }

    public static final class Builder {
        private AccessRights oldPrivileges;
        private AccessRights newPrivileges;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder oldPrivileges(AccessRights oldPrivileges) {
            this.oldPrivileges = oldPrivileges;
            this.changedFields = changedFields.add("OldPrivileges");
            return this;
        }

        public Builder newPrivileges(AccessRights newPrivileges) {
            this.newPrivileges = newPrivileges;
            this.changedFields = changedFields.add("NewPrivileges");
            return this;
        }

        public ShareAuditDetail build() {
            ShareAuditDetail _x = new ShareAuditDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ShareAuditDetail";
            _x.oldPrivileges = oldPrivileges;
            _x.newPrivileges = newPrivileges;
            return _x;
        }
    }

    private ShareAuditDetail _copy() {
        ShareAuditDetail _x = new ShareAuditDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.oldPrivileges = oldPrivileges;
        _x.newPrivileges = newPrivileges;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ShareAuditDetail[");
        b.append("OldPrivileges=");
        b.append(this.oldPrivileges);
        b.append(", ");
        b.append("NewPrivileges=");
        b.append(this.newPrivileges);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
