package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "Proposals", 
    "TraceInfo"})
@JsonInclude(Include.NON_NULL)
public class SearchResults implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Proposals")
    protected List<AppointmentProposal> proposals;

    @JsonProperty("Proposals@nextLink")
    protected String proposalsNextLink;

    @JsonProperty("TraceInfo")
    protected TraceInfo traceInfo;

    protected SearchResults() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SearchResults";
    }

    @Property(name="Proposals")
    @JsonIgnore
    public CollectionPage<AppointmentProposal> getProposals() {
        return new CollectionPage<AppointmentProposal>(contextPath, AppointmentProposal.class, this.proposals, Optional.ofNullable(proposalsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Proposals")
    @JsonIgnore
    public CollectionPage<AppointmentProposal> getProposals(HttpRequestOptions options) {
        return new CollectionPage<AppointmentProposal>(contextPath, AppointmentProposal.class, this.proposals, Optional.ofNullable(proposalsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="TraceInfo")
    @JsonIgnore
    public Optional<TraceInfo> getTraceInfo() {
        return Optional.ofNullable(traceInfo);
    }

    public SearchResults withTraceInfo(TraceInfo traceInfo) {
        SearchResults _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SearchResults");
        _x.traceInfo = traceInfo;
        return _x;
    }

    public SearchResults withUnmappedField(String name, String value) {
        SearchResults _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AppointmentProposal> proposals;
        private String proposalsNextLink;
        private TraceInfo traceInfo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder proposals(List<AppointmentProposal> proposals) {
            this.proposals = proposals;
            this.changedFields = changedFields.add("Proposals");
            return this;
        }

        public Builder proposals(AppointmentProposal... proposals) {
            return proposals(Arrays.asList(proposals));
        }

        public Builder proposalsNextLink(String proposalsNextLink) {
            this.proposalsNextLink = proposalsNextLink;
            this.changedFields = changedFields.add("Proposals");
            return this;
        }

        public Builder traceInfo(TraceInfo traceInfo) {
            this.traceInfo = traceInfo;
            this.changedFields = changedFields.add("TraceInfo");
            return this;
        }

        public SearchResults build() {
            SearchResults _x = new SearchResults();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SearchResults";
            _x.proposals = proposals;
            _x.proposalsNextLink = proposalsNextLink;
            _x.traceInfo = traceInfo;
            return _x;
        }
    }

    private SearchResults _copy() {
        SearchResults _x = new SearchResults();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.proposals = proposals;
        _x.traceInfo = traceInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchResults[");
        b.append("Proposals=");
        b.append(this.proposals);
        b.append(", ");
        b.append("TraceInfo=");
        b.append(this.traceInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
